/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.floatingpoint;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;

public class FromString {
    private static final BString ERROR_REASON = ErrorReasons.getModulePrefixedReason("lang.float", "NumberParsingError");

    private FromString() {
    }

    public static Object fromString(BString s) {
        String decimalFloatingPointNumber = s.getValue();
        try {
            return TypeConverter.stringToFloat(decimalFloatingPointNumber);
        }
        catch (NumberFormatException e) {
            return FromString.getTypeConversionError(decimalFloatingPointNumber);
        }
    }

    private static BError getTypeConversionError(String value2) {
        return ErrorCreator.createError(ERROR_REASON, ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, PredefinedTypes.TYPE_STRING, value2, PredefinedTypes.TYPE_FLOAT));
    }
}

