/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.internal;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langlib.internal.GetElements;

public final class GetFilteredChildrenFlat {
    private GetFilteredChildrenFlat() {
    }

    public static BXml getFilteredChildrenFlat(BXml xmlVal, long index, BString[] elemNames) {
        if (xmlVal.getNodeType() == XmlNodeType.ELEMENT) {
            BXmlItem element = (BXmlItem)xmlVal;
            return ValueCreator.createXmlSequence(GetFilteredChildrenFlat.filterElementChildren(index, elemNames, element));
        }
        if (xmlVal.getNodeType() == XmlNodeType.SEQUENCE) {
            BXmlSequence sequence = (BXmlSequence)xmlVal;
            ArrayList<BXml> liftedFilteredChildren = new ArrayList<BXml>();
            for (BXml child : sequence.getChildrenList()) {
                if (child.getNodeType() != XmlNodeType.ELEMENT) continue;
                liftedFilteredChildren.addAll(GetFilteredChildrenFlat.filterElementChildren(index, elemNames, (BXmlItem)child));
            }
            return ValueCreator.createXmlSequence(liftedFilteredChildren);
        }
        return ValueCreator.createXmlSequence();
    }

    private static List<BXml> filterElementChildren(long index, BString[] elemNames, BXmlItem element) {
        BXmlSequence elements = (BXmlSequence)GetElements.getElements(element.getChildrenSeq(), elemNames);
        if (index < 0L) {
            return elements.getChildrenList();
        }
        if ((long)elements.getChildrenList().size() > index) {
            return Collections.singletonList(elements.getChildrenList().get((int)index));
        }
        return new ArrayList<BXml>();
    }
}

