/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.utils.MapUtils;
import java.util.Collection;
import org.ballerinalang.langlib.map.util.MapLibUtils;

public final class ToArray {
    private ToArray() {
    }

    public static BArray toArray(BMap<?, ?> m) {
        Type mapType = TypeUtils.getImpliedType(m.getType());
        Type arrElemType = switch (mapType.getTag()) {
            case 27 -> ((MapType)mapType).getConstrainedType();
            case 24 -> MapLibUtils.getCommonTypeForRecordField((RecordType)mapType);
            default -> throw MapUtils.createOpNotSupportedError(mapType, "toArray()");
        };
        Collection<?> values = m.values();
        int size = values.size();
        int i = 0;
        switch (TypeUtils.getImpliedType(arrElemType).getTag()) {
            case 1: {
                long[] intArr = new long[size];
                for (Object val2 : values) {
                    intArr[i++] = (Long)val2;
                }
                return ValueCreator.createArrayValue(intArr);
            }
            case 3: {
                double[] floatArr = new double[size];
                for (Object val3 : values) {
                    floatArr[i++] = (Double)val3;
                }
                return ValueCreator.createArrayValue(floatArr);
            }
            case 2: {
                byte[] byteArr = new byte[size];
                for (Object val4 : values) {
                    byteArr[i++] = ((Integer)val4).byteValue();
                }
                return ValueCreator.createArrayValue(byteArr);
            }
            case 6: {
                boolean[] booleanArr = new boolean[size];
                for (Object val5 : values) {
                    booleanArr[i++] = (Boolean)val5;
                }
                return ValueCreator.createArrayValue(booleanArr);
            }
            case 5: {
                BString[] stringArr = new BString[size];
                for (Object val6 : values) {
                    stringArr[i++] = (BString)val6;
                }
                return ValueCreator.createArrayValue(stringArr);
            }
        }
        return ValueCreator.createArrayValue(values.toArray(), TypeCreator.createArrayType(arrElemType));
    }
}

