/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.string;

import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import org.ballerinalang.langlib.string.utils.StringUtils;

public final class Substring {
    private Substring() {
    }

    public static BString substring(BString value2, long startIndex, long endIndex) {
        if (value2 == null) {
            throw StringUtils.createNullReferenceError();
        }
        if (startIndex != (long)((int)startIndex)) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.STRING_OPERATION_ERROR, ErrorCodes.INDEX_NUMBER_TOO_LARGE, startIndex);
        }
        if (endIndex != (long)((int)endIndex)) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.STRING_OPERATION_ERROR, ErrorCodes.INDEX_NUMBER_TOO_LARGE, endIndex);
        }
        if (startIndex < 0L || endIndex > (long)value2.length()) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.STRING_OPERATION_ERROR, ErrorCodes.SUBSTRING_INDEX_OUT_OF_RANGE, value2.length(), startIndex, endIndex);
        }
        if (endIndex < startIndex) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.STRING_OPERATION_ERROR, ErrorCodes.INVALID_SUBSTRING_RANGE, value2.length(), startIndex, endIndex);
        }
        return value2.substring((int)startIndex, (int)endIndex);
    }
}

