/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.runtime;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BString;
import java.math.BigDecimal;

public final class Sleep {
    private static final BigDecimal LONG_MAX = new BigDecimal(Long.MAX_VALUE);

    public static void sleep(Environment env, BDecimal delaySeconds) {
        BigDecimal delayDecimal = delaySeconds.decimalValue();
        if (delayDecimal.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        long delay = (delayDecimal = delayDecimal.multiply(new BigDecimal("1000.0"))).compareTo(LONG_MAX) > 0 ? Long.MAX_VALUE : delayDecimal.longValue();
        env.yieldAndRun(() -> {
            try {
                Thread.sleep(delay);
                return null;
            }
            catch (InterruptedException e) {
                throw ErrorCreator.createError((BString)StringUtils.fromString((String)"error occurred during sleep"), (Throwable)e);
            }
        });
    }

    private Sleep() {
    }
}

