/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.exporter;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class InMemorySpanExporter
implements SpanExporter {
    private final List<SpanData> finishedSpanItems = new ArrayList<SpanData>();
    private boolean isStopped = false;

    public static InMemorySpanExporter create() {
        return new InMemorySpanExporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SpanData> getFinishedSpanItems() {
        InMemorySpanExporter inMemorySpanExporter = this;
        synchronized (inMemorySpanExporter) {
            return Collections.unmodifiableList(new ArrayList<SpanData>(this.finishedSpanItems));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        InMemorySpanExporter inMemorySpanExporter = this;
        synchronized (inMemorySpanExporter) {
            this.finishedSpanItems.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode export(Collection<SpanData> spans) {
        InMemorySpanExporter inMemorySpanExporter = this;
        synchronized (inMemorySpanExporter) {
            if (this.isStopped) {
                return CompletableResultCode.ofFailure();
            }
            this.finishedSpanItems.addAll(spans);
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableResultCode shutdown() {
        InMemorySpanExporter inMemorySpanExporter = this;
        synchronized (inMemorySpanExporter) {
            this.finishedSpanItems.clear();
            this.isStopped = true;
        }
        return CompletableResultCode.ofSuccess();
    }

    private InMemorySpanExporter() {
    }
}

