/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.annotations;

import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.validators.ArrayConstraintValidator;
import io.ballerina.stdlib.constraint.validators.DateConstraintValidator;
import io.ballerina.stdlib.constraint.validators.FloatConstraintValidator;
import io.ballerina.stdlib.constraint.validators.IntConstraintValidator;
import io.ballerina.stdlib.constraint.validators.NumberConstraintValidator;
import io.ballerina.stdlib.constraint.validators.StringConstraintValidator;
import java.util.List;
import java.util.Map;

public abstract class AbstractAnnotations {
    private final IntConstraintValidator intConstraintValidator;
    private final FloatConstraintValidator floatConstraintValidator;
    private final NumberConstraintValidator numberConstraintValidator;
    private final StringConstraintValidator stringConstraintValidator;
    private final ArrayConstraintValidator arrayConstraintValidator;
    private final DateConstraintValidator dateConstraintValidator;

    public AbstractAnnotations(List<ConstraintErrorInfo> failedConstraintsInfo) {
        this.intConstraintValidator = new IntConstraintValidator(failedConstraintsInfo);
        this.floatConstraintValidator = new FloatConstraintValidator(failedConstraintsInfo);
        this.numberConstraintValidator = new NumberConstraintValidator(failedConstraintsInfo);
        this.stringConstraintValidator = new StringConstraintValidator(failedConstraintsInfo);
        this.arrayConstraintValidator = new ArrayConstraintValidator(failedConstraintsInfo);
        this.dateConstraintValidator = new DateConstraintValidator(failedConstraintsInfo);
    }

    public abstract void validate(Object var1, AnnotatableType var2, String var3, boolean var4);

    public void validateAnnotations(BMap<BString, Object> annotations, Object fieldValue, String path, boolean isMemberValue) {
        for (Map.Entry annotationRecord : annotations.entrySet()) {
            if (!AbstractAnnotations.fromConstraintModule(annotationRecord)) continue;
            String annotationTag = ((BString)annotationRecord.getKey()).getValue().split(":", 3)[2];
            BMap constraints = (BMap)annotationRecord.getValue();
            this.validateAnnotationTags(annotationTag, (BMap<BString, Object>)constraints, fieldValue, path, isMemberValue);
        }
    }

    public static boolean fromConstraintModule(Map.Entry<BString, Object> annotationRecord) {
        return annotationRecord.getKey().getValue().matches("^ballerina/constraint:[0-9]+:.+");
    }

    private void validateAnnotationTags(String annotationTag, BMap<BString, Object> constraints, Object fieldValue, String path, boolean isMemberValue) {
        switch (annotationTag) {
            case "Int": {
                this.intConstraintValidator.validate(constraints, (Number)fieldValue, path, isMemberValue);
                break;
            }
            case "Float": {
                this.floatConstraintValidator.validate(constraints, (Number)fieldValue, path, isMemberValue);
                break;
            }
            case "Number": {
                this.numberConstraintValidator.validate(constraints, (Number)fieldValue, path, isMemberValue);
                break;
            }
            case "String": {
                this.stringConstraintValidator.validate(constraints, (String)fieldValue, path, isMemberValue);
                break;
            }
            case "Array": {
                this.arrayConstraintValidator.validate(constraints, (Long)fieldValue, path, isMemberValue);
                break;
            }
            case "Date": {
                this.dateConstraintValidator.validate(constraints, fieldValue, path, isMemberValue);
                break;
            }
        }
    }
}

