/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.compiler.internal.diagnostics.DiagnosticWarningCode;
import io.ballerina.compiler.internal.parser.ParserRuleContext;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeFactory;
import io.ballerina.compiler.internal.parser.tree.STNodeList;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.internal.syntax.NodeListUtils;
import io.ballerina.compiler.internal.syntax.SyntaxUtils;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SyntaxErrors {
    private SyntaxErrors() {
    }

    public static STNodeDiagnostic createDiagnostic(DiagnosticCode diagnosticCode, Object ... args) {
        return STNodeDiagnostic.from(diagnosticCode, args);
    }

    public static <T extends STNode> T addDiagnostic(T node, DiagnosticCode diagnosticCode, Object ... args) {
        return SyntaxErrors.addSyntaxDiagnostic(node, SyntaxErrors.createDiagnostic(diagnosticCode, args));
    }

    public static <T extends STNode> T addSyntaxDiagnostic(T node, STNodeDiagnostic diagnostic) {
        return SyntaxErrors.addSyntaxDiagnostics(node, Collections.singletonList(diagnostic));
    }

    public static <T extends STNode> T addSyntaxDiagnostics(T node, Collection<STNodeDiagnostic> diagnostics) {
        ArrayList<STNodeDiagnostic> newDiagnostics;
        if (diagnostics.isEmpty()) {
            return node;
        }
        Collection<STNodeDiagnostic> oldDiagnostics = node.diagnostics();
        if (oldDiagnostics.isEmpty()) {
            newDiagnostics = new ArrayList<STNodeDiagnostic>(diagnostics);
        } else {
            newDiagnostics = new ArrayList<STNodeDiagnostic>(oldDiagnostics);
            newDiagnostics.addAll(diagnostics);
        }
        return (T)node.modifyWith(newDiagnostics);
    }

    public static STToken createMissingToken(SyntaxKind expectedKind) {
        return STNodeFactory.createMissingToken(expectedKind);
    }

    public static STToken createMissingTokenWithDiagnostics(SyntaxKind expectedKind, ParserRuleContext currentCtx) {
        return SyntaxErrors.createMissingTokenWithDiagnostics(expectedKind, SyntaxErrors.getErrorCode(currentCtx));
    }

    public static STToken createMissingDocTokenWithDiagnostics(SyntaxKind expectedKind) {
        return SyntaxErrors.createMissingTokenWithDiagnostics(expectedKind, SyntaxErrors.getDocWarningCode(expectedKind));
    }

    public static STToken createMissingRegExpTokenWithDiagnostics(SyntaxKind expectedKind) {
        return SyntaxErrors.createMissingTokenWithDiagnostics(expectedKind, SyntaxErrors.getRegExpErrorCode(expectedKind));
    }

    public static STToken createMissingTokenWithDiagnostics(SyntaxKind expectedKind, DiagnosticCode diagnosticCode) {
        ArrayList<STNodeDiagnostic> diagnosticList = new ArrayList<STNodeDiagnostic>();
        diagnosticList.add(SyntaxErrors.createDiagnostic(diagnosticCode, new Object[0]));
        return STNodeFactory.createMissingToken(expectedKind, diagnosticList);
    }

    private static DiagnosticCode getErrorCode(ParserRuleContext currentCtx) {
        return switch (currentCtx) {
            case ParserRuleContext.EXTERNAL_FUNC_BODY -> DiagnosticErrorCode.ERROR_MISSING_EQUAL_TOKEN;
            case ParserRuleContext.FUNC_BODY_BLOCK -> DiagnosticErrorCode.ERROR_MISSING_OPEN_BRACE_TOKEN;
            case ParserRuleContext.FUNC_DEF, ParserRuleContext.FUNC_DEF_OR_FUNC_TYPE, ParserRuleContext.FUNC_TYPE_DESC, ParserRuleContext.FUNC_TYPE_DESC_OR_ANON_FUNC, ParserRuleContext.IDENT_AFTER_OBJECT_IDENT, ParserRuleContext.FUNC_DEF_FIRST_QUALIFIER, ParserRuleContext.FUNC_DEF_SECOND_QUALIFIER, ParserRuleContext.FUNC_TYPE_FIRST_QUALIFIER, ParserRuleContext.FUNC_TYPE_SECOND_QUALIFIER, ParserRuleContext.OBJECT_METHOD_FIRST_QUALIFIER, ParserRuleContext.OBJECT_METHOD_SECOND_QUALIFIER, ParserRuleContext.OBJECT_METHOD_THIRD_QUALIFIER, ParserRuleContext.OBJECT_METHOD_FOURTH_QUALIFIER -> DiagnosticErrorCode.ERROR_MISSING_FUNCTION_KEYWORD;
            case ParserRuleContext.SINGLE_KEYWORD_ATTACH_POINT_IDENT -> DiagnosticErrorCode.ERROR_MISSING_ATTACH_POINT_NAME;
            case ParserRuleContext.SIMPLE_TYPE_DESCRIPTOR -> DiagnosticErrorCode.ERROR_MISSING_BUILTIN_TYPE;
            case ParserRuleContext.REQUIRED_PARAM, ParserRuleContext.VAR_DECL_STMT, ParserRuleContext.ASSIGNMENT_OR_VAR_DECL_STMT, ParserRuleContext.DEFAULTABLE_PARAM, ParserRuleContext.REST_PARAM, ParserRuleContext.TYPE_DESCRIPTOR, ParserRuleContext.OPTIONAL_TYPE_DESCRIPTOR, ParserRuleContext.ARRAY_TYPE_DESCRIPTOR, ParserRuleContext.SIMPLE_TYPE_DESC_IDENTIFIER -> DiagnosticErrorCode.ERROR_MISSING_TYPE_DESC;
            case ParserRuleContext.TYPE_REFERENCE -> DiagnosticErrorCode.ERROR_MISSING_TYPE_REFERENCE;
            case ParserRuleContext.TYPE_NAME, ParserRuleContext.TYPE_REFERENCE_IN_TYPE_INCLUSION, ParserRuleContext.FIELD_ACCESS_IDENTIFIER, ParserRuleContext.CLASS_NAME, ParserRuleContext.FUNC_NAME, ParserRuleContext.VARIABLE_NAME, ParserRuleContext.IMPORT_MODULE_NAME, ParserRuleContext.IMPORT_ORG_OR_MODULE_NAME, ParserRuleContext.IMPORT_PREFIX, ParserRuleContext.VARIABLE_REF, ParserRuleContext.BASIC_LITERAL, ParserRuleContext.IDENTIFIER, ParserRuleContext.QUALIFIED_IDENTIFIER_START_IDENTIFIER, ParserRuleContext.NAMESPACE_PREFIX, ParserRuleContext.IMPLICIT_ANON_FUNC_PARAM, ParserRuleContext.METHOD_NAME, ParserRuleContext.PEER_WORKER_NAME, ParserRuleContext.RECEIVE_FIELD_NAME, ParserRuleContext.WAIT_FIELD_NAME, ParserRuleContext.FIELD_BINDING_PATTERN_NAME, ParserRuleContext.XML_ATOMIC_NAME_IDENTIFIER, ParserRuleContext.MAPPING_FIELD_NAME, ParserRuleContext.WORKER_NAME, ParserRuleContext.NAMED_WORKERS, ParserRuleContext.ANNOTATION_TAG, ParserRuleContext.AFTER_PARAMETER_TYPE, ParserRuleContext.MODULE_ENUM_NAME, ParserRuleContext.ENUM_MEMBER_NAME, ParserRuleContext.TYPED_BINDING_PATTERN_TYPE_RHS, ParserRuleContext.ASSIGNMENT_STMT, ParserRuleContext.XML_NAME, ParserRuleContext.ACCESS_EXPRESSION, ParserRuleContext.BINDING_PATTERN_STARTING_IDENTIFIER, ParserRuleContext.COMPUTED_FIELD_NAME, ParserRuleContext.SIMPLE_BINDING_PATTERN, ParserRuleContext.ERROR_FIELD_BINDING_PATTERN, ParserRuleContext.ERROR_CAUSE_SIMPLE_BINDING_PATTERN, ParserRuleContext.PATH_SEGMENT_IDENT, ParserRuleContext.NAMED_ARG_BINDING_PATTERN, ParserRuleContext.MODULE_VAR_FIRST_QUAL, ParserRuleContext.MODULE_VAR_SECOND_QUAL, ParserRuleContext.MODULE_VAR_THIRD_QUAL, ParserRuleContext.OBJECT_MEMBER_VISIBILITY_QUAL -> DiagnosticErrorCode.ERROR_MISSING_IDENTIFIER;
            case ParserRuleContext.EXPRESSION, ParserRuleContext.TERMINAL_EXPRESSION -> DiagnosticErrorCode.ERROR_MISSING_EXPRESSION;
            case ParserRuleContext.STRING_LITERAL_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_STRING_LITERAL;
            case ParserRuleContext.DECIMAL_INTEGER_LITERAL_TOKEN, ParserRuleContext.SIGNED_INT_OR_FLOAT_RHS -> DiagnosticErrorCode.ERROR_MISSING_DECIMAL_INTEGER_LITERAL;
            case ParserRuleContext.HEX_INTEGER_LITERAL_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_HEX_INTEGER_LITERAL;
            case ParserRuleContext.OBJECT_FIELD_RHS, ParserRuleContext.BINDING_PATTERN_OR_VAR_REF_RHS -> DiagnosticErrorCode.ERROR_MISSING_SEMICOLON_TOKEN;
            case ParserRuleContext.NIL_LITERAL, ParserRuleContext.ERROR_MATCH_PATTERN -> DiagnosticErrorCode.ERROR_MISSING_ERROR_KEYWORD;
            case ParserRuleContext.DECIMAL_FLOATING_POINT_LITERAL_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_DECIMAL_FLOATING_POINT_LITERAL;
            case ParserRuleContext.HEX_FLOATING_POINT_LITERAL_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_HEX_FLOATING_POINT_LITERAL;
            case ParserRuleContext.STATEMENT, ParserRuleContext.STATEMENT_WITHOUT_ANNOTS -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACE_TOKEN;
            case ParserRuleContext.XML_COMMENT_CONTENT, ParserRuleContext.XML_PI_DATA -> DiagnosticErrorCode.ERROR_MISSING_XML_TEXT_CONTENT;
            default -> SyntaxErrors.getSeperatorTokenErrorCode(currentCtx);
        };
    }

    private static DiagnosticCode getSeperatorTokenErrorCode(ParserRuleContext ctx) {
        return switch (ctx) {
            case ParserRuleContext.BITWISE_AND_OPERATOR -> DiagnosticErrorCode.ERROR_MISSING_BITWISE_AND_TOKEN;
            case ParserRuleContext.EQUAL_OR_RIGHT_ARROW, ParserRuleContext.ASSIGN_OP -> DiagnosticErrorCode.ERROR_MISSING_EQUAL_TOKEN;
            case ParserRuleContext.BINARY_OPERATOR, ParserRuleContext.UNARY_OPERATOR, ParserRuleContext.COMPOUND_BINARY_OPERATOR, ParserRuleContext.UNARY_EXPRESSION, ParserRuleContext.EXPRESSION_RHS, ParserRuleContext.PLUS_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_BINARY_OPERATOR;
            case ParserRuleContext.CLOSE_BRACE -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACE_TOKEN;
            case ParserRuleContext.CLOSE_PARENTHESIS, ParserRuleContext.ARG_LIST_CLOSE_PAREN -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_PAREN_TOKEN;
            case ParserRuleContext.COMMA, ParserRuleContext.ERROR_MESSAGE_BINDING_PATTERN_END_COMMA, ParserRuleContext.ERROR_MESSAGE_MATCH_PATTERN_END_COMMA -> DiagnosticErrorCode.ERROR_MISSING_COMMA_TOKEN;
            case ParserRuleContext.OPEN_BRACE -> DiagnosticErrorCode.ERROR_MISSING_OPEN_BRACE_TOKEN;
            case ParserRuleContext.OPEN_PARENTHESIS, ParserRuleContext.ARG_LIST_OPEN_PAREN, ParserRuleContext.PARENTHESISED_TYPE_DESC_START -> DiagnosticErrorCode.ERROR_MISSING_OPEN_PAREN_TOKEN;
            case ParserRuleContext.OBJECT_FIELD_RHS, ParserRuleContext.SEMICOLON -> DiagnosticErrorCode.ERROR_MISSING_SEMICOLON_TOKEN;
            case ParserRuleContext.ASTERISK -> DiagnosticErrorCode.ERROR_MISSING_ASTERISK_TOKEN;
            case ParserRuleContext.CLOSED_RECORD_BODY_END -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACE_PIPE_TOKEN;
            case ParserRuleContext.CLOSED_RECORD_BODY_START -> DiagnosticErrorCode.ERROR_MISSING_OPEN_BRACE_PIPE_TOKEN;
            case ParserRuleContext.ELLIPSIS -> DiagnosticErrorCode.ERROR_MISSING_ELLIPSIS_TOKEN;
            case ParserRuleContext.QUESTION_MARK -> DiagnosticErrorCode.ERROR_MISSING_QUESTION_MARK_TOKEN;
            case ParserRuleContext.CLOSE_BRACKET -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACKET_TOKEN;
            case ParserRuleContext.DOT, ParserRuleContext.METHOD_CALL_DOT -> DiagnosticErrorCode.ERROR_MISSING_DOT_TOKEN;
            case ParserRuleContext.OPEN_BRACKET, ParserRuleContext.TUPLE_TYPE_DESC_START -> DiagnosticErrorCode.ERROR_MISSING_OPEN_BRACKET_TOKEN;
            case ParserRuleContext.SLASH, ParserRuleContext.ABSOLUTE_PATH_SINGLE_SLASH, ParserRuleContext.RESOURCE_METHOD_CALL_SLASH_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_SLASH_TOKEN;
            case ParserRuleContext.COLON, ParserRuleContext.VAR_REF_COLON, ParserRuleContext.TYPE_REF_COLON -> DiagnosticErrorCode.ERROR_MISSING_COLON_TOKEN;
            case ParserRuleContext.AT -> DiagnosticErrorCode.ERROR_MISSING_AT_TOKEN;
            case ParserRuleContext.RIGHT_ARROW -> DiagnosticErrorCode.ERROR_MISSING_RIGHT_ARROW_TOKEN;
            case ParserRuleContext.GT, ParserRuleContext.GT_TOKEN, ParserRuleContext.XML_START_OR_EMPTY_TAG_END, ParserRuleContext.XML_ATTRIBUTES, ParserRuleContext.INFERRED_TYPEDESC_DEFAULT_END_GT -> DiagnosticErrorCode.ERROR_MISSING_GT_TOKEN;
            case ParserRuleContext.LT, ParserRuleContext.LT_TOKEN, ParserRuleContext.XML_START_OR_EMPTY_TAG, ParserRuleContext.XML_END_TAG, ParserRuleContext.INFERRED_TYPEDESC_DEFAULT_START_LT, ParserRuleContext.STREAM_TYPE_PARAM_START_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_LT_TOKEN;
            case ParserRuleContext.SYNC_SEND_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_SYNC_SEND_TOKEN;
            case ParserRuleContext.ANNOT_CHAINING_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_ANNOT_CHAINING_TOKEN;
            case ParserRuleContext.OPTIONAL_CHAINING_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_OPTIONAL_CHAINING_TOKEN;
            case ParserRuleContext.DOT_LT_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_DOT_LT_TOKEN;
            case ParserRuleContext.SLASH_LT_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_SLASH_LT_TOKEN;
            case ParserRuleContext.DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_DOUBLE_SLASH_DOUBLE_ASTERISK_LT_TOKEN;
            case ParserRuleContext.SLASH_ASTERISK_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_SLASH_ASTERISK_TOKEN;
            case ParserRuleContext.MINUS_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_MINUS_TOKEN;
            case ParserRuleContext.LEFT_ARROW_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_LEFT_ARROW_TOKEN;
            case ParserRuleContext.TEMPLATE_END, ParserRuleContext.TEMPLATE_START, ParserRuleContext.XML_CONTENT, ParserRuleContext.XML_TEXT -> DiagnosticErrorCode.ERROR_MISSING_BACKTICK_TOKEN;
            case ParserRuleContext.XML_COMMENT_START -> DiagnosticErrorCode.ERROR_MISSING_XML_COMMENT_START_TOKEN;
            case ParserRuleContext.XML_COMMENT_END -> DiagnosticErrorCode.ERROR_MISSING_XML_COMMENT_END_TOKEN;
            case ParserRuleContext.XML_PI, ParserRuleContext.XML_PI_START -> DiagnosticErrorCode.ERROR_MISSING_XML_PI_START_TOKEN;
            case ParserRuleContext.XML_PI_END -> DiagnosticErrorCode.ERROR_MISSING_XML_PI_END_TOKEN;
            case ParserRuleContext.XML_QUOTE_END, ParserRuleContext.XML_QUOTE_START -> DiagnosticErrorCode.ERROR_MISSING_DOUBLE_QUOTE_TOKEN;
            case ParserRuleContext.INTERPOLATION_START_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_INTERPOLATION_START_TOKEN;
            case ParserRuleContext.EXPR_FUNC_BODY_START, ParserRuleContext.RIGHT_DOUBLE_ARROW -> DiagnosticErrorCode.ERROR_MISSING_RIGHT_DOUBLE_ARROW_TOKEN;
            case ParserRuleContext.XML_CDATA_END -> DiagnosticErrorCode.ERROR_MISSING_XML_CDATA_END_TOKEN;
            default -> SyntaxErrors.getKeywordErrorCode(ctx);
        };
    }

    private static DiagnosticCode getKeywordErrorCode(ParserRuleContext ctx) {
        return switch (ctx) {
            case ParserRuleContext.PUBLIC_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_PUBLIC_KEYWORD;
            case ParserRuleContext.PRIVATE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_PRIVATE_KEYWORD;
            case ParserRuleContext.ABSTRACT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_ABSTRACT_KEYWORD;
            case ParserRuleContext.CLIENT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_CLIENT_KEYWORD;
            case ParserRuleContext.IMPORT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_IMPORT_KEYWORD;
            case ParserRuleContext.FUNCTION_KEYWORD, ParserRuleContext.FUNCTION_IDENT, ParserRuleContext.OPTIONAL_PEER_WORKER, ParserRuleContext.DEFAULT_WORKER_NAME_IN_ASYNC_SEND -> DiagnosticErrorCode.ERROR_MISSING_FUNCTION_KEYWORD;
            case ParserRuleContext.CONST_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_CONST_KEYWORD;
            case ParserRuleContext.LISTENER_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_LISTENER_KEYWORD;
            case ParserRuleContext.SERVICE_KEYWORD, ParserRuleContext.SERVICE_IDENT, ParserRuleContext.SERVICE_DECL_QUALIFIER -> DiagnosticErrorCode.ERROR_MISSING_SERVICE_KEYWORD;
            case ParserRuleContext.XMLNS_KEYWORD, ParserRuleContext.XML_NAMESPACE_DECLARATION -> DiagnosticErrorCode.ERROR_MISSING_XMLNS_KEYWORD;
            case ParserRuleContext.ANNOTATION_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_ANNOTATION_KEYWORD;
            case ParserRuleContext.TYPE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_TYPE_KEYWORD;
            case ParserRuleContext.RECORD_KEYWORD, ParserRuleContext.RECORD_FIELD, ParserRuleContext.RECORD_IDENT -> DiagnosticErrorCode.ERROR_MISSING_RECORD_KEYWORD;
            case ParserRuleContext.OBJECT_KEYWORD, ParserRuleContext.OBJECT_IDENT, ParserRuleContext.OBJECT_TYPE_DESCRIPTOR, ParserRuleContext.FIRST_OBJECT_CONS_QUALIFIER, ParserRuleContext.SECOND_OBJECT_CONS_QUALIFIER, ParserRuleContext.FIRST_OBJECT_TYPE_QUALIFIER, ParserRuleContext.SECOND_OBJECT_TYPE_QUALIFIER -> DiagnosticErrorCode.ERROR_MISSING_OBJECT_KEYWORD;
            case ParserRuleContext.AS_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_AS_KEYWORD;
            case ParserRuleContext.ON_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_ON_KEYWORD;
            case ParserRuleContext.FINAL_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_FINAL_KEYWORD;
            case ParserRuleContext.SOURCE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_SOURCE_KEYWORD;
            case ParserRuleContext.WORKER_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_WORKER_KEYWORD;
            case ParserRuleContext.FIELD_IDENT -> DiagnosticErrorCode.ERROR_MISSING_FIELD_KEYWORD;
            case ParserRuleContext.RETURNS_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_RETURNS_KEYWORD;
            case ParserRuleContext.RETURN_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_RETURN_KEYWORD;
            case ParserRuleContext.EXTERNAL_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_EXTERNAL_KEYWORD;
            case ParserRuleContext.BOOLEAN_LITERAL -> DiagnosticErrorCode.ERROR_MISSING_TRUE_KEYWORD;
            case ParserRuleContext.IF_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_IF_KEYWORD;
            case ParserRuleContext.ELSE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_ELSE_KEYWORD;
            case ParserRuleContext.WHILE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_WHILE_KEYWORD;
            case ParserRuleContext.CHECKING_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_CHECK_KEYWORD;
            case ParserRuleContext.PANIC_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_PANIC_KEYWORD;
            case ParserRuleContext.CONTINUE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_CONTINUE_KEYWORD;
            case ParserRuleContext.BREAK_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_BREAK_KEYWORD;
            case ParserRuleContext.TYPEOF_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_TYPEOF_KEYWORD;
            case ParserRuleContext.IS_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_IS_KEYWORD;
            case ParserRuleContext.NULL_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_NULL_KEYWORD;
            case ParserRuleContext.LOCK_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_LOCK_KEYWORD;
            case ParserRuleContext.FORK_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_FORK_KEYWORD;
            case ParserRuleContext.TRAP_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_TRAP_KEYWORD;
            case ParserRuleContext.IN_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_IN_KEYWORD;
            case ParserRuleContext.FOREACH_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_FOREACH_KEYWORD;
            case ParserRuleContext.TABLE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_TABLE_KEYWORD;
            case ParserRuleContext.KEY_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_KEY_KEYWORD;
            case ParserRuleContext.LET_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_LET_KEYWORD;
            case ParserRuleContext.NEW_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_NEW_KEYWORD;
            case ParserRuleContext.FROM_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_FROM_KEYWORD;
            case ParserRuleContext.WHERE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_WHERE_KEYWORD;
            case ParserRuleContext.SELECT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_SELECT_KEYWORD;
            case ParserRuleContext.START_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_START_KEYWORD;
            case ParserRuleContext.FLUSH_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_FLUSH_KEYWORD;
            case ParserRuleContext.WAIT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_WAIT_KEYWORD;
            case ParserRuleContext.DO_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_DO_KEYWORD;
            case ParserRuleContext.TRANSACTION_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_TRANSACTION_KEYWORD;
            case ParserRuleContext.TRANSACTIONAL_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_TRANSACTIONAL_KEYWORD;
            case ParserRuleContext.COMMIT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_COMMIT_KEYWORD;
            case ParserRuleContext.ROLLBACK_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_ROLLBACK_KEYWORD;
            case ParserRuleContext.RETRY_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_RETRY_KEYWORD;
            case ParserRuleContext.ENUM_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_ENUM_KEYWORD;
            case ParserRuleContext.BASE16_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_BASE16_KEYWORD;
            case ParserRuleContext.BASE64_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_BASE64_KEYWORD;
            case ParserRuleContext.MATCH_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_MATCH_KEYWORD;
            case ParserRuleContext.CONFLICT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_CONFLICT_KEYWORD;
            case ParserRuleContext.LIMIT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_LIMIT_KEYWORD;
            case ParserRuleContext.ORDER_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_ORDER_KEYWORD;
            case ParserRuleContext.BY_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_BY_KEYWORD;
            case ParserRuleContext.GROUP_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_GROUP_KEYWORD;
            case ParserRuleContext.ORDER_DIRECTION -> DiagnosticErrorCode.ERROR_MISSING_ASCENDING_KEYWORD;
            case ParserRuleContext.JOIN_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_JOIN_KEYWORD;
            case ParserRuleContext.OUTER_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_OUTER_KEYWORD;
            case ParserRuleContext.FAIL_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_FAIL_KEYWORD;
            case ParserRuleContext.PIPE, ParserRuleContext.UNION_OR_INTERSECTION_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_PIPE_TOKEN;
            case ParserRuleContext.EQUALS_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_EQUALS_KEYWORD;
            case ParserRuleContext.REMOTE_IDENT -> DiagnosticErrorCode.ERROR_MISSING_REMOTE_KEYWORD;
            case ParserRuleContext.STRING_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_STRING_KEYWORD;
            case ParserRuleContext.XML_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_XML_KEYWORD;
            case ParserRuleContext.RE_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_RE_KEYWORD;
            case ParserRuleContext.VAR_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_VAR_KEYWORD;
            case ParserRuleContext.MAP_KEYWORD, ParserRuleContext.NAMED_WORKER_DECL, ParserRuleContext.MAP_TYPE_DESCRIPTOR -> DiagnosticErrorCode.ERROR_MISSING_MAP_KEYWORD;
            case ParserRuleContext.ERROR_KEYWORD, ParserRuleContext.ERROR_BINDING_PATTERN, ParserRuleContext.PARAMETERIZED_TYPE -> DiagnosticErrorCode.ERROR_MISSING_ERROR_KEYWORD;
            case ParserRuleContext.STREAM_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_STREAM_KEYWORD;
            case ParserRuleContext.READONLY_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_READONLY_KEYWORD;
            case ParserRuleContext.DISTINCT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_DISTINCT_KEYWORD;
            case ParserRuleContext.CLASS_KEYWORD, ParserRuleContext.FIRST_CLASS_TYPE_QUALIFIER, ParserRuleContext.SECOND_CLASS_TYPE_QUALIFIER, ParserRuleContext.THIRD_CLASS_TYPE_QUALIFIER, ParserRuleContext.FOURTH_CLASS_TYPE_QUALIFIER -> DiagnosticErrorCode.ERROR_MISSING_CLASS_KEYWORD;
            case ParserRuleContext.COLLECT_KEYWORD -> DiagnosticErrorCode.ERROR_MISSING_COLLECT_KEYWORD;
            default -> DiagnosticErrorCode.ERROR_SYNTAX_ERROR;
        };
    }

    private static DiagnosticCode getDocWarningCode(SyntaxKind expectedKind) {
        return switch (expectedKind) {
            case SyntaxKind.HASH_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_HASH_TOKEN;
            case SyntaxKind.BACKTICK_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_SINGLE_BACKTICK_TOKEN;
            case SyntaxKind.DOUBLE_BACKTICK_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_DOUBLE_BACKTICK_TOKEN;
            case SyntaxKind.TRIPLE_BACKTICK_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_TRIPLE_BACKTICK_TOKEN;
            case SyntaxKind.IDENTIFIER_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_IDENTIFIER_TOKEN;
            case SyntaxKind.OPEN_PAREN_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_OPEN_PAREN_TOKEN;
            case SyntaxKind.CLOSE_PAREN_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_CLOSE_PAREN_TOKEN;
            case SyntaxKind.MINUS_TOKEN -> DiagnosticWarningCode.WARNING_MISSING_HYPHEN_TOKEN;
            case SyntaxKind.PARAMETER_NAME -> DiagnosticWarningCode.WARNING_MISSING_PARAMETER_NAME;
            case SyntaxKind.CODE_CONTENT -> DiagnosticWarningCode.WARNING_MISSING_CODE_REFERENCE;
            default -> DiagnosticWarningCode.WARNING_SYNTAX_WARNING;
        };
    }

    private static DiagnosticCode getRegExpErrorCode(SyntaxKind expectedKind) {
        return switch (expectedKind) {
            case SyntaxKind.CLOSE_PAREN_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_PAREN_TOKEN;
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACKET_TOKEN;
            case SyntaxKind.OPEN_BRACE_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_OPEN_BRACE_TOKEN;
            case SyntaxKind.CLOSE_BRACE_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_CLOSE_BRACE_TOKEN;
            case SyntaxKind.COLON_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_COLON_TOKEN;
            case SyntaxKind.RE_UNICODE_PROPERTY_VALUE -> DiagnosticErrorCode.ERROR_MISSING_RE_UNICODE_PROPERTY_VALUE;
            case SyntaxKind.DIGIT -> DiagnosticErrorCode.ERROR_MISSING_RE_QUANTIFIER_DIGIT;
            case SyntaxKind.BITWISE_XOR_TOKEN -> DiagnosticErrorCode.ERROR_INVALID_RE_SYNTAX_CHAR;
            case SyntaxKind.BACK_SLASH_TOKEN -> DiagnosticErrorCode.ERROR_MISSING_BACKSLASH;
            default -> DiagnosticErrorCode.ERROR_SYNTAX_ERROR;
        };
    }

    public static STNode updateAllNodesInNodeListWithDiagnostic(STNodeList nodeList, DiagnosticErrorCode errorCode) {
        ArrayList<STNode> newList = new ArrayList<STNode>();
        for (int i = 0; i < nodeList.size(); ++i) {
            STNode updatedNode = SyntaxErrors.addDiagnostic(nodeList.get(i), errorCode, new Object[0]);
            newList.add(updatedNode);
        }
        return STNodeFactory.createNodeList(newList);
    }

    public static STNode cloneWithLeadingInvalidNodeMinutiae(STNode toClone, STNode invalidNode) {
        return SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(toClone, invalidNode, null, new Object[0]);
    }

    public static STNode cloneWithLeadingInvalidNodeMinutiae(STNode toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args) {
        STToken firstToken = toClone.firstToken();
        STToken firstTokenWithInvalidNodeMinutiae = SyntaxErrors.cloneWithLeadingInvalidNodeMinutiae(firstToken, invalidNode, diagnosticCode, args);
        return toClone.replace(firstToken, firstTokenWithInvalidNodeMinutiae);
    }

    public static STToken cloneWithLeadingInvalidNodeMinutiae(STToken toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args) {
        List<STNode> minutiaeList = SyntaxErrors.convertInvalidNodeToMinutiae(invalidNode, diagnosticCode, args);
        STNodeList leadingMinutiae = (STNodeList)toClone.leadingMinutiae();
        leadingMinutiae = leadingMinutiae.addAll(0, minutiaeList);
        return toClone.modifyWith(leadingMinutiae, toClone.trailingMinutiae());
    }

    public static STNode cloneWithTrailingInvalidNodeMinutiae(STNode toClone, STNode invalidNode) {
        return SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(toClone, invalidNode, null, new Object[0]);
    }

    public static STNode cloneWithTrailingInvalidNodeMinutiae(STNode toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args) {
        STToken lastToken = toClone.lastToken();
        STToken lastTokenWithInvalidNodeMinutiae = SyntaxErrors.cloneWithTrailingInvalidNodeMinutiae(lastToken, invalidNode, diagnosticCode, args);
        return toClone.replace(lastToken, lastTokenWithInvalidNodeMinutiae);
    }

    public static STToken cloneWithTrailingInvalidNodeMinutiae(STToken toClone, STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args) {
        List<STNode> minutiaeList = SyntaxErrors.convertInvalidNodeToMinutiae(invalidNode, diagnosticCode, args);
        STNodeList trailingMinutiae = (STNodeList)toClone.trailingMinutiae();
        trailingMinutiae = trailingMinutiae.addAll(minutiaeList);
        return toClone.modifyWith(toClone.leadingMinutiae(), trailingMinutiae);
    }

    private static List<STNode> convertInvalidNodeToMinutiae(STNode invalidNode, DiagnosticCode diagnosticCode, Object ... args) {
        ArrayList<STNode> minutiaeList = new ArrayList<STNode>();
        List<STToken> tokens = invalidNode.tokens();
        for (STToken token : tokens) {
            SyntaxErrors.addMinutiaeToList(minutiaeList, token.leadingMinutiae());
            if (!token.isMissing()) {
                if (diagnosticCode != null) {
                    token = SyntaxErrors.addDiagnostic(token, diagnosticCode, args);
                    diagnosticCode = null;
                }
                STToken tokenWithNoMinutiae = token.modifyWith(STNodeFactory.createEmptyNodeList(), STNodeFactory.createEmptyNodeList());
                minutiaeList.add(STNodeFactory.createInvalidNodeMinutiae(tokenWithNoMinutiae));
            }
            SyntaxErrors.addMinutiaeToList(minutiaeList, token.trailingMinutiae());
        }
        return minutiaeList;
    }

    private static void addMinutiaeToList(List<STNode> list, STNode minutiae) {
        if (!NodeListUtils.isSTNodeList(minutiae)) {
            list.add(minutiae);
            return;
        }
        STNodeList minutiaeList = (STNodeList)minutiae;
        for (int index = 0; index < minutiaeList.size(); ++index) {
            STNode element = minutiaeList.get(index);
            if (!SyntaxUtils.isSTNodePresent(element)) continue;
            list.add(element);
        }
    }
}

