/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.ForkStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STForkStatementNode
extends STStatementNode {
    public final STNode forkKeyword;
    public final STNode openBraceToken;
    public final STNode namedWorkerDeclarations;
    public final STNode closeBraceToken;

    STForkStatementNode(STNode forkKeyword, STNode openBraceToken, STNode namedWorkerDeclarations, STNode closeBraceToken) {
        this(forkKeyword, openBraceToken, namedWorkerDeclarations, closeBraceToken, Collections.emptyList());
    }

    STForkStatementNode(STNode forkKeyword, STNode openBraceToken, STNode namedWorkerDeclarations, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FORK_STATEMENT, diagnostics);
        this.forkKeyword = forkKeyword;
        this.openBraceToken = openBraceToken;
        this.namedWorkerDeclarations = namedWorkerDeclarations;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(forkKeyword, openBraceToken, namedWorkerDeclarations, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STForkStatementNode(this.forkKeyword, this.openBraceToken, this.namedWorkerDeclarations, this.closeBraceToken, diagnostics);
    }

    public STForkStatementNode modify(STNode forkKeyword, STNode openBraceToken, STNode namedWorkerDeclarations, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(forkKeyword, openBraceToken, namedWorkerDeclarations, closeBraceToken)) {
            return this;
        }
        return new STForkStatementNode(forkKeyword, openBraceToken, namedWorkerDeclarations, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ForkStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

