/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STFunctionSignatureNode
extends STNode {
    public final STNode openParenToken;
    public final STNode parameters;
    public final STNode closeParenToken;
    public final STNode returnTypeDesc;

    STFunctionSignatureNode(STNode openParenToken, STNode parameters, STNode closeParenToken, STNode returnTypeDesc) {
        this(openParenToken, parameters, closeParenToken, returnTypeDesc, Collections.emptyList());
    }

    STFunctionSignatureNode(STNode openParenToken, STNode parameters, STNode closeParenToken, STNode returnTypeDesc, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FUNCTION_SIGNATURE, diagnostics);
        this.openParenToken = openParenToken;
        this.parameters = parameters;
        this.closeParenToken = closeParenToken;
        this.returnTypeDesc = returnTypeDesc;
        this.addChildren(openParenToken, parameters, closeParenToken, returnTypeDesc);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STFunctionSignatureNode(this.openParenToken, this.parameters, this.closeParenToken, this.returnTypeDesc, diagnostics);
    }

    public STFunctionSignatureNode modify(STNode openParenToken, STNode parameters, STNode closeParenToken, STNode returnTypeDesc) {
        if (this.checkForReferenceEquality(openParenToken, parameters, closeParenToken, returnTypeDesc)) {
            return this;
        }
        return new STFunctionSignatureNode(openParenToken, parameters, closeParenToken, returnTypeDesc, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new FunctionSignatureNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

