/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.FunctionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STFunctionTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode qualifierList;
    public final STNode functionKeyword;
    public final STNode functionSignature;

    STFunctionTypeDescriptorNode(STNode qualifierList, STNode functionKeyword, STNode functionSignature) {
        this(qualifierList, functionKeyword, functionSignature, Collections.emptyList());
    }

    STFunctionTypeDescriptorNode(STNode qualifierList, STNode functionKeyword, STNode functionSignature, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FUNCTION_TYPE_DESC, diagnostics);
        this.qualifierList = qualifierList;
        this.functionKeyword = functionKeyword;
        this.functionSignature = functionSignature;
        this.addChildren(qualifierList, functionKeyword, functionSignature);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STFunctionTypeDescriptorNode(this.qualifierList, this.functionKeyword, this.functionSignature, diagnostics);
    }

    public STFunctionTypeDescriptorNode modify(STNode qualifierList, STNode functionKeyword, STNode functionSignature) {
        if (this.checkForReferenceEquality(qualifierList, functionKeyword, functionSignature)) {
            return this;
        }
        return new STFunctionTypeDescriptorNode(qualifierList, functionKeyword, functionSignature, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new FunctionTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

