/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STIfElseStatementNode
extends STStatementNode {
    public final STNode ifKeyword;
    public final STNode condition;
    public final STNode ifBody;
    public final STNode elseBody;

    STIfElseStatementNode(STNode ifKeyword, STNode condition, STNode ifBody, STNode elseBody) {
        this(ifKeyword, condition, ifBody, elseBody, Collections.emptyList());
    }

    STIfElseStatementNode(STNode ifKeyword, STNode condition, STNode ifBody, STNode elseBody, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.IF_ELSE_STATEMENT, diagnostics);
        this.ifKeyword = ifKeyword;
        this.condition = condition;
        this.ifBody = ifBody;
        this.elseBody = elseBody;
        this.addChildren(ifKeyword, condition, ifBody, elseBody);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STIfElseStatementNode(this.ifKeyword, this.condition, this.ifBody, this.elseBody, diagnostics);
    }

    public STIfElseStatementNode modify(STNode ifKeyword, STNode condition, STNode ifBody, STNode elseBody) {
        if (this.checkForReferenceEquality(ifKeyword, condition, ifBody, elseBody)) {
            return this;
        }
        return new STIfElseStatementNode(ifKeyword, condition, ifBody, elseBody, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new IfElseStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

