/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNewExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STImplicitNewExpressionNode
extends STNewExpressionNode {
    public final STNode newKeyword;
    public final STNode parenthesizedArgList;

    STImplicitNewExpressionNode(STNode newKeyword, STNode parenthesizedArgList) {
        this(newKeyword, parenthesizedArgList, Collections.emptyList());
    }

    STImplicitNewExpressionNode(STNode newKeyword, STNode parenthesizedArgList, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.IMPLICIT_NEW_EXPRESSION, diagnostics);
        this.newKeyword = newKeyword;
        this.parenthesizedArgList = parenthesizedArgList;
        this.addChildren(newKeyword, parenthesizedArgList);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STImplicitNewExpressionNode(this.newKeyword, this.parenthesizedArgList, diagnostics);
    }

    public STImplicitNewExpressionNode modify(STNode newKeyword, STNode parenthesizedArgList) {
        if (this.checkForReferenceEquality(newKeyword, parenthesizedArgList)) {
            return this;
        }
        return new STImplicitNewExpressionNode(newKeyword, parenthesizedArgList, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ImplicitNewExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

