/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMapTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode mapKeywordToken;
    public final STNode mapTypeParamsNode;

    STMapTypeDescriptorNode(STNode mapKeywordToken, STNode mapTypeParamsNode) {
        this(mapKeywordToken, mapTypeParamsNode, Collections.emptyList());
    }

    STMapTypeDescriptorNode(STNode mapKeywordToken, STNode mapTypeParamsNode, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MAP_TYPE_DESC, diagnostics);
        this.mapKeywordToken = mapKeywordToken;
        this.mapTypeParamsNode = mapTypeParamsNode;
        this.addChildren(mapKeywordToken, mapTypeParamsNode);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMapTypeDescriptorNode(this.mapKeywordToken, this.mapTypeParamsNode, diagnostics);
    }

    public STMapTypeDescriptorNode modify(STNode mapKeywordToken, STNode mapTypeParamsNode) {
        if (this.checkForReferenceEquality(mapKeywordToken, mapTypeParamsNode)) {
            return this;
        }
        return new STMapTypeDescriptorNode(mapKeywordToken, mapTypeParamsNode, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MapTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

