/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMethodCallExpressionNode
extends STExpressionNode {
    public final STNode expression;
    public final STNode dotToken;
    public final STNode methodName;
    public final STNode openParenToken;
    public final STNode arguments;
    public final STNode closeParenToken;

    STMethodCallExpressionNode(STNode expression, STNode dotToken, STNode methodName, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        this(expression, dotToken, methodName, openParenToken, arguments, closeParenToken, Collections.emptyList());
    }

    STMethodCallExpressionNode(STNode expression, STNode dotToken, STNode methodName, STNode openParenToken, STNode arguments, STNode closeParenToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.METHOD_CALL, diagnostics);
        this.expression = expression;
        this.dotToken = dotToken;
        this.methodName = methodName;
        this.openParenToken = openParenToken;
        this.arguments = arguments;
        this.closeParenToken = closeParenToken;
        this.addChildren(expression, dotToken, methodName, openParenToken, arguments, closeParenToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMethodCallExpressionNode(this.expression, this.dotToken, this.methodName, this.openParenToken, this.arguments, this.closeParenToken, diagnostics);
    }

    public STMethodCallExpressionNode modify(STNode expression, STNode dotToken, STNode methodName, STNode openParenToken, STNode arguments, STNode closeParenToken) {
        if (this.checkForReferenceEquality(expression, dotToken, methodName, openParenToken, arguments, closeParenToken)) {
            return this;
        }
        return new STMethodCallExpressionNode(expression, dotToken, methodName, openParenToken, arguments, closeParenToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MethodCallExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

