/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STOnFailClauseNode
extends STClauseNode {
    public final STNode onKeyword;
    public final STNode failKeyword;
    public final STNode typedBindingPattern;
    public final STNode blockStatement;

    STOnFailClauseNode(STNode onKeyword, STNode failKeyword, STNode typedBindingPattern, STNode blockStatement) {
        this(onKeyword, failKeyword, typedBindingPattern, blockStatement, Collections.emptyList());
    }

    STOnFailClauseNode(STNode onKeyword, STNode failKeyword, STNode typedBindingPattern, STNode blockStatement, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ON_FAIL_CLAUSE, diagnostics);
        this.onKeyword = onKeyword;
        this.failKeyword = failKeyword;
        this.typedBindingPattern = typedBindingPattern;
        this.blockStatement = blockStatement;
        this.addChildren(onKeyword, failKeyword, typedBindingPattern, blockStatement);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STOnFailClauseNode(this.onKeyword, this.failKeyword, this.typedBindingPattern, this.blockStatement, diagnostics);
    }

    public STOnFailClauseNode modify(STNode onKeyword, STNode failKeyword, STNode typedBindingPattern, STNode blockStatement) {
        if (this.checkForReferenceEquality(onKeyword, failKeyword, typedBindingPattern, blockStatement)) {
            return this;
        }
        return new STOnFailClauseNode(onKeyword, failKeyword, typedBindingPattern, blockStatement, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new OnFailClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

