/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STOptionalFieldAccessExpressionNode
extends STExpressionNode {
    public final STNode expression;
    public final STNode optionalChainingToken;
    public final STNode fieldName;

    STOptionalFieldAccessExpressionNode(STNode expression, STNode optionalChainingToken, STNode fieldName) {
        this(expression, optionalChainingToken, fieldName, Collections.emptyList());
    }

    STOptionalFieldAccessExpressionNode(STNode expression, STNode optionalChainingToken, STNode fieldName, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.OPTIONAL_FIELD_ACCESS, diagnostics);
        this.expression = expression;
        this.optionalChainingToken = optionalChainingToken;
        this.fieldName = fieldName;
        this.addChildren(expression, optionalChainingToken, fieldName);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STOptionalFieldAccessExpressionNode(this.expression, this.optionalChainingToken, this.fieldName, diagnostics);
    }

    public STOptionalFieldAccessExpressionNode modify(STNode expression, STNode optionalChainingToken, STNode fieldName) {
        if (this.checkForReferenceEquality(expression, optionalChainingToken, fieldName)) {
            return this;
        }
        return new STOptionalFieldAccessExpressionNode(expression, optionalChainingToken, fieldName, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new OptionalFieldAccessExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

