/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.PanicStatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STPanicStatementNode
extends STStatementNode {
    public final STNode panicKeyword;
    public final STNode expression;
    public final STNode semicolonToken;

    STPanicStatementNode(STNode panicKeyword, STNode expression, STNode semicolonToken) {
        this(panicKeyword, expression, semicolonToken, Collections.emptyList());
    }

    STPanicStatementNode(STNode panicKeyword, STNode expression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.PANIC_STATEMENT, diagnostics);
        this.panicKeyword = panicKeyword;
        this.expression = expression;
        this.semicolonToken = semicolonToken;
        this.addChildren(panicKeyword, expression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STPanicStatementNode(this.panicKeyword, this.expression, this.semicolonToken, diagnostics);
    }

    public STPanicStatementNode modify(STNode panicKeyword, STNode expression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(panicKeyword, expression, semicolonToken)) {
            return this;
        }
        return new STPanicStatementNode(panicKeyword, expression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new PanicStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

