/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReceiveFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReceiveFieldNode
extends STNode {
    public final STNode fieldName;
    public final STNode colon;
    public final STNode peerWorker;

    STReceiveFieldNode(STNode fieldName, STNode colon, STNode peerWorker) {
        this(fieldName, colon, peerWorker, Collections.emptyList());
    }

    STReceiveFieldNode(STNode fieldName, STNode colon, STNode peerWorker, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RECEIVE_FIELD, diagnostics);
        this.fieldName = fieldName;
        this.colon = colon;
        this.peerWorker = peerWorker;
        this.addChildren(fieldName, colon, peerWorker);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReceiveFieldNode(this.fieldName, this.colon, this.peerWorker, diagnostics);
    }

    public STReceiveFieldNode modify(STNode fieldName, STNode colon, STNode peerWorker) {
        if (this.checkForReferenceEquality(fieldName, colon, peerWorker)) {
            return this;
        }
        return new STReceiveFieldNode(fieldName, colon, peerWorker, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReceiveFieldNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

