/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ResourceAccessRestSegmentNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STResourceAccessRestSegmentNode
extends STNode {
    public final STNode openBracketToken;
    public final STNode ellipsisToken;
    public final STNode expression;
    public final STNode closeBracketToken;

    STResourceAccessRestSegmentNode(STNode openBracketToken, STNode ellipsisToken, STNode expression, STNode closeBracketToken) {
        this(openBracketToken, ellipsisToken, expression, closeBracketToken, Collections.emptyList());
    }

    STResourceAccessRestSegmentNode(STNode openBracketToken, STNode ellipsisToken, STNode expression, STNode closeBracketToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RESOURCE_ACCESS_REST_SEGMENT, diagnostics);
        this.openBracketToken = openBracketToken;
        this.ellipsisToken = ellipsisToken;
        this.expression = expression;
        this.closeBracketToken = closeBracketToken;
        this.addChildren(openBracketToken, ellipsisToken, expression, closeBracketToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STResourceAccessRestSegmentNode(this.openBracketToken, this.ellipsisToken, this.expression, this.closeBracketToken, diagnostics);
    }

    public STResourceAccessRestSegmentNode modify(STNode openBracketToken, STNode ellipsisToken, STNode expression, STNode closeBracketToken) {
        if (this.checkForReferenceEquality(openBracketToken, ellipsisToken, expression, closeBracketToken)) {
            return this;
        }
        return new STResourceAccessRestSegmentNode(openBracketToken, ellipsisToken, expression, closeBracketToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ResourceAccessRestSegmentNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

