/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STMappingFieldNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SpreadFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STSpreadFieldNode
extends STMappingFieldNode {
    public final STNode ellipsis;
    public final STNode valueExpr;

    STSpreadFieldNode(STNode ellipsis, STNode valueExpr) {
        this(ellipsis, valueExpr, Collections.emptyList());
    }

    STSpreadFieldNode(STNode ellipsis, STNode valueExpr, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.SPREAD_FIELD, diagnostics);
        this.ellipsis = ellipsis;
        this.valueExpr = valueExpr;
        this.addChildren(ellipsis, valueExpr);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STSpreadFieldNode(this.ellipsis, this.valueExpr, diagnostics);
    }

    public STSpreadFieldNode modify(STNode ellipsis, STNode valueExpr) {
        if (this.checkForReferenceEquality(ellipsis, valueExpr)) {
            return this;
        }
        return new STSpreadFieldNode(ellipsis, valueExpr, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new SpreadFieldNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

