/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STStreamTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode streamKeywordToken;
    public final STNode streamTypeParamsNode;

    STStreamTypeDescriptorNode(STNode streamKeywordToken, STNode streamTypeParamsNode) {
        this(streamKeywordToken, streamTypeParamsNode, Collections.emptyList());
    }

    STStreamTypeDescriptorNode(STNode streamKeywordToken, STNode streamTypeParamsNode, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.STREAM_TYPE_DESC, diagnostics);
        this.streamKeywordToken = streamKeywordToken;
        this.streamTypeParamsNode = streamTypeParamsNode;
        this.addChildren(streamKeywordToken, streamTypeParamsNode);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STStreamTypeDescriptorNode(this.streamKeywordToken, this.streamTypeParamsNode, diagnostics);
    }

    public STStreamTypeDescriptorNode modify(STNode streamKeywordToken, STNode streamTypeParamsNode) {
        if (this.checkForReferenceEquality(streamKeywordToken, streamTypeParamsNode)) {
            return this;
        }
        return new STStreamTypeDescriptorNode(streamKeywordToken, streamTypeParamsNode, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new StreamTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

