/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STActionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyncSendActionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STSyncSendActionNode
extends STActionNode {
    public final STNode expression;
    public final STNode syncSendToken;
    public final STNode peerWorker;

    STSyncSendActionNode(STNode expression, STNode syncSendToken, STNode peerWorker) {
        this(expression, syncSendToken, peerWorker, Collections.emptyList());
    }

    STSyncSendActionNode(STNode expression, STNode syncSendToken, STNode peerWorker, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.SYNC_SEND_ACTION, diagnostics);
        this.expression = expression;
        this.syncSendToken = syncSendToken;
        this.peerWorker = peerWorker;
        this.addChildren(expression, syncSendToken, peerWorker);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STSyncSendActionNode(this.expression, this.syncSendToken, this.peerWorker, diagnostics);
    }

    public STSyncSendActionNode modify(STNode expression, STNode syncSendToken, STNode peerWorker) {
        if (this.checkForReferenceEquality(expression, syncSendToken, peerWorker)) {
            return this;
        }
        return new STSyncSendActionNode(expression, syncSendToken, peerWorker, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new SyncSendActionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

