/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import java.util.Collection;
import java.util.Collections;

public class STTableTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode tableKeywordToken;
    public final STNode rowTypeParameterNode;
    public final STNode keyConstraintNode;

    STTableTypeDescriptorNode(STNode tableKeywordToken, STNode rowTypeParameterNode, STNode keyConstraintNode) {
        this(tableKeywordToken, rowTypeParameterNode, keyConstraintNode, Collections.emptyList());
    }

    STTableTypeDescriptorNode(STNode tableKeywordToken, STNode rowTypeParameterNode, STNode keyConstraintNode, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TABLE_TYPE_DESC, diagnostics);
        this.tableKeywordToken = tableKeywordToken;
        this.rowTypeParameterNode = rowTypeParameterNode;
        this.keyConstraintNode = keyConstraintNode;
        this.addChildren(tableKeywordToken, rowTypeParameterNode, keyConstraintNode);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTableTypeDescriptorNode(this.tableKeywordToken, this.rowTypeParameterNode, this.keyConstraintNode, diagnostics);
    }

    public STTableTypeDescriptorNode modify(STNode tableKeywordToken, STNode rowTypeParameterNode, STNode keyConstraintNode) {
        if (this.checkForReferenceEquality(tableKeywordToken, rowTypeParameterNode, keyConstraintNode)) {
            return this;
        }
        return new STTableTypeDescriptorNode(tableKeywordToken, rowTypeParameterNode, keyConstraintNode, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TableTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

