/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TupleTypeDescriptorNode;
import java.util.Collection;
import java.util.Collections;

public class STTupleTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode openBracketToken;
    public final STNode memberTypeDesc;
    public final STNode closeBracketToken;

    STTupleTypeDescriptorNode(STNode openBracketToken, STNode memberTypeDesc, STNode closeBracketToken) {
        this(openBracketToken, memberTypeDesc, closeBracketToken, Collections.emptyList());
    }

    STTupleTypeDescriptorNode(STNode openBracketToken, STNode memberTypeDesc, STNode closeBracketToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TUPLE_TYPE_DESC, diagnostics);
        this.openBracketToken = openBracketToken;
        this.memberTypeDesc = memberTypeDesc;
        this.closeBracketToken = closeBracketToken;
        this.addChildren(openBracketToken, memberTypeDesc, closeBracketToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTupleTypeDescriptorNode(this.openBracketToken, this.memberTypeDesc, this.closeBracketToken, diagnostics);
    }

    public STTupleTypeDescriptorNode modify(STNode openBracketToken, STNode memberTypeDesc, STNode closeBracketToken) {
        if (this.checkForReferenceEquality(openBracketToken, memberTypeDesc, closeBracketToken)) {
            return this;
        }
        return new STTupleTypeDescriptorNode(openBracketToken, memberTypeDesc, closeBracketToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TupleTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

