/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLAtomicNamePatternNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLAtomicNamePatternNode
extends STNode {
    public final STNode prefix;
    public final STNode colon;
    public final STNode name;

    STXMLAtomicNamePatternNode(STNode prefix, STNode colon, STNode name) {
        this(prefix, colon, name, Collections.emptyList());
    }

    STXMLAtomicNamePatternNode(STNode prefix, STNode colon, STNode name, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_ATOMIC_NAME_PATTERN, diagnostics);
        this.prefix = prefix;
        this.colon = colon;
        this.name = name;
        this.addChildren(prefix, colon, name);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLAtomicNamePatternNode(this.prefix, this.colon, this.name, diagnostics);
    }

    public STXMLAtomicNamePatternNode modify(STNode prefix, STNode colon, STNode name) {
        if (this.checkForReferenceEquality(prefix, colon, name)) {
            return this;
        }
        return new STXMLAtomicNamePatternNode(prefix, colon, name, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLAtomicNamePatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

