/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STXMLNameNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLQualifiedNameNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLQualifiedNameNode
extends STXMLNameNode {
    public final STNode prefix;
    public final STNode colon;
    public final STNode name;

    STXMLQualifiedNameNode(STNode prefix, STNode colon, STNode name) {
        this(prefix, colon, name, Collections.emptyList());
    }

    STXMLQualifiedNameNode(STNode prefix, STNode colon, STNode name, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_QUALIFIED_NAME, diagnostics);
        this.prefix = prefix;
        this.colon = colon;
        this.name = name;
        this.addChildren(prefix, colon, name);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLQualifiedNameNode(this.prefix, this.colon, this.name, diagnostics);
    }

    public STXMLQualifiedNameNode modify(STNode prefix, STNode colon, STNode name) {
        if (this.checkForReferenceEquality(prefix, colon, name)) {
            return this;
        }
        return new STXMLQualifiedNameNode(prefix, colon, name, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLQualifiedNameNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

