/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class BallerinaNameReferenceNode
extends DocumentationNode {
    public BallerinaNameReferenceNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> referenceType() {
        return this.optionalChildInBucket(0);
    }

    public Token startBacktick() {
        return (Token)this.childInBucket(1);
    }

    public Node nameReference() {
        return this.childInBucket(2);
    }

    public Token endBacktick() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"referenceType", "startBacktick", "nameReference", "endBacktick"};
    }

    public BallerinaNameReferenceNode modify(Token referenceType, Token startBacktick, Node nameReference, Token endBacktick) {
        if (this.checkForReferenceEquality(referenceType, startBacktick, nameReference, endBacktick)) {
            return this;
        }
        return NodeFactory.createBallerinaNameReferenceNode(referenceType, startBacktick, nameReference, endBacktick);
    }

    public BallerinaNameReferenceNodeModifier modify() {
        return new BallerinaNameReferenceNodeModifier(this);
    }

    public static class BallerinaNameReferenceNodeModifier {
        private final BallerinaNameReferenceNode oldNode;
        private Token referenceType;
        private Token startBacktick;
        private Node nameReference;
        private Token endBacktick;

        public BallerinaNameReferenceNodeModifier(BallerinaNameReferenceNode oldNode) {
            this.oldNode = oldNode;
            this.referenceType = oldNode.referenceType().orElse(null);
            this.startBacktick = oldNode.startBacktick();
            this.nameReference = oldNode.nameReference();
            this.endBacktick = oldNode.endBacktick();
        }

        public BallerinaNameReferenceNodeModifier withReferenceType(Token referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public BallerinaNameReferenceNodeModifier withStartBacktick(Token startBacktick) {
            Objects.requireNonNull(startBacktick, "startBacktick must not be null");
            this.startBacktick = startBacktick;
            return this;
        }

        public BallerinaNameReferenceNodeModifier withNameReference(Node nameReference) {
            Objects.requireNonNull(nameReference, "nameReference must not be null");
            this.nameReference = nameReference;
            return this;
        }

        public BallerinaNameReferenceNodeModifier withEndBacktick(Token endBacktick) {
            Objects.requireNonNull(endBacktick, "endBacktick must not be null");
            this.endBacktick = endBacktick;
            return this;
        }

        public BallerinaNameReferenceNode apply() {
            return this.oldNode.modify(this.referenceType, this.startBacktick, this.nameReference, this.endBacktick);
        }
    }
}

