/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class BasicLiteralNode
extends ExpressionNode {
    public BasicLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token literalToken() {
        return (Token)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"literalToken"};
    }

    public BasicLiteralNode modify(SyntaxKind kind, Token literalToken) {
        if (this.checkForReferenceEquality(literalToken)) {
            return this;
        }
        return NodeFactory.createBasicLiteralNode(kind, literalToken);
    }

    public BasicLiteralNodeModifier modify() {
        return new BasicLiteralNodeModifier(this);
    }

    public static class BasicLiteralNodeModifier {
        private final BasicLiteralNode oldNode;
        private Token literalToken;

        public BasicLiteralNodeModifier(BasicLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.literalToken = oldNode.literalToken();
        }

        public BasicLiteralNodeModifier withLiteralToken(Token literalToken) {
            Objects.requireNonNull(literalToken, "literalToken must not be null");
            this.literalToken = literalToken;
            return this;
        }

        public BasicLiteralNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.literalToken);
        }
    }
}

