/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ExplicitAnonymousFunctionExpressionNode
extends AnonymousFunctionExpressionNode {
    public ExplicitAnonymousFunctionExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public NodeList<Token> qualifierList() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(1));
    }

    public Token functionKeyword() {
        return (Token)this.childInBucket(2);
    }

    public FunctionSignatureNode functionSignature() {
        return (FunctionSignatureNode)this.childInBucket(3);
    }

    public FunctionBodyNode functionBody() {
        return (FunctionBodyNode)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"annotations", "qualifierList", "functionKeyword", "functionSignature", "functionBody"};
    }

    public ExplicitAnonymousFunctionExpressionNode modify(NodeList<AnnotationNode> annotations, NodeList<Token> qualifierList, Token functionKeyword, FunctionSignatureNode functionSignature, FunctionBodyNode functionBody) {
        if (this.checkForReferenceEquality(annotations.underlyingListNode(), qualifierList.underlyingListNode(), functionKeyword, functionSignature, functionBody)) {
            return this;
        }
        return NodeFactory.createExplicitAnonymousFunctionExpressionNode(annotations, qualifierList, functionKeyword, functionSignature, functionBody);
    }

    public ExplicitAnonymousFunctionExpressionNodeModifier modify() {
        return new ExplicitAnonymousFunctionExpressionNodeModifier(this);
    }

    public static class ExplicitAnonymousFunctionExpressionNodeModifier {
        private final ExplicitAnonymousFunctionExpressionNode oldNode;
        private NodeList<AnnotationNode> annotations;
        private NodeList<Token> qualifierList;
        private Token functionKeyword;
        private FunctionSignatureNode functionSignature;
        private FunctionBodyNode functionBody;

        public ExplicitAnonymousFunctionExpressionNodeModifier(ExplicitAnonymousFunctionExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.annotations = oldNode.annotations();
            this.qualifierList = oldNode.qualifierList();
            this.functionKeyword = oldNode.functionKeyword();
            this.functionSignature = oldNode.functionSignature();
            this.functionBody = oldNode.functionBody();
        }

        public ExplicitAnonymousFunctionExpressionNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public ExplicitAnonymousFunctionExpressionNodeModifier withQualifierList(NodeList<Token> qualifierList) {
            Objects.requireNonNull(qualifierList, "qualifierList must not be null");
            this.qualifierList = qualifierList;
            return this;
        }

        public ExplicitAnonymousFunctionExpressionNodeModifier withFunctionKeyword(Token functionKeyword) {
            Objects.requireNonNull(functionKeyword, "functionKeyword must not be null");
            this.functionKeyword = functionKeyword;
            return this;
        }

        public ExplicitAnonymousFunctionExpressionNodeModifier withFunctionSignature(FunctionSignatureNode functionSignature) {
            Objects.requireNonNull(functionSignature, "functionSignature must not be null");
            this.functionSignature = functionSignature;
            return this;
        }

        public ExplicitAnonymousFunctionExpressionNodeModifier withFunctionBody(FunctionBodyNode functionBody) {
            Objects.requireNonNull(functionBody, "functionBody must not be null");
            this.functionBody = functionBody;
            return this;
        }

        public ExplicitAnonymousFunctionExpressionNode apply() {
            return this.oldNode.modify(this.annotations, this.qualifierList, this.functionKeyword, this.functionSignature, this.functionBody);
        }
    }
}

