/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class FieldAccessExpressionNode
extends ExpressionNode {
    public FieldAccessExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token dotToken() {
        return (Token)this.childInBucket(1);
    }

    public NameReferenceNode fieldName() {
        return (NameReferenceNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "dotToken", "fieldName"};
    }

    public FieldAccessExpressionNode modify(ExpressionNode expression, Token dotToken, NameReferenceNode fieldName) {
        if (this.checkForReferenceEquality(expression, dotToken, fieldName)) {
            return this;
        }
        return NodeFactory.createFieldAccessExpressionNode(expression, dotToken, fieldName);
    }

    public FieldAccessExpressionNodeModifier modify() {
        return new FieldAccessExpressionNodeModifier(this);
    }

    public static class FieldAccessExpressionNodeModifier {
        private final FieldAccessExpressionNode oldNode;
        private ExpressionNode expression;
        private Token dotToken;
        private NameReferenceNode fieldName;

        public FieldAccessExpressionNodeModifier(FieldAccessExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.dotToken = oldNode.dotToken();
            this.fieldName = oldNode.fieldName();
        }

        public FieldAccessExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public FieldAccessExpressionNodeModifier withDotToken(Token dotToken) {
            Objects.requireNonNull(dotToken, "dotToken must not be null");
            this.dotToken = dotToken;
            return this;
        }

        public FieldAccessExpressionNodeModifier withFieldName(NameReferenceNode fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public FieldAccessExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.dotToken, this.fieldName);
        }
    }
}

