/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Objects;

public class FromClauseNode
extends IntermediateClauseNode {
    public FromClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token fromKeyword() {
        return (Token)this.childInBucket(0);
    }

    public TypedBindingPatternNode typedBindingPattern() {
        return (TypedBindingPatternNode)this.childInBucket(1);
    }

    public Token inKeyword() {
        return (Token)this.childInBucket(2);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"fromKeyword", "typedBindingPattern", "inKeyword", "expression"};
    }

    public FromClauseNode modify(Token fromKeyword, TypedBindingPatternNode typedBindingPattern, Token inKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(fromKeyword, typedBindingPattern, inKeyword, expression)) {
            return this;
        }
        return NodeFactory.createFromClauseNode(fromKeyword, typedBindingPattern, inKeyword, expression);
    }

    public FromClauseNodeModifier modify() {
        return new FromClauseNodeModifier(this);
    }

    public static class FromClauseNodeModifier {
        private final FromClauseNode oldNode;
        private Token fromKeyword;
        private TypedBindingPatternNode typedBindingPattern;
        private Token inKeyword;
        private ExpressionNode expression;

        public FromClauseNodeModifier(FromClauseNode oldNode) {
            this.oldNode = oldNode;
            this.fromKeyword = oldNode.fromKeyword();
            this.typedBindingPattern = oldNode.typedBindingPattern();
            this.inKeyword = oldNode.inKeyword();
            this.expression = oldNode.expression();
        }

        public FromClauseNodeModifier withFromKeyword(Token fromKeyword) {
            Objects.requireNonNull(fromKeyword, "fromKeyword must not be null");
            this.fromKeyword = fromKeyword;
            return this;
        }

        public FromClauseNodeModifier withTypedBindingPattern(TypedBindingPatternNode typedBindingPattern) {
            Objects.requireNonNull(typedBindingPattern, "typedBindingPattern must not be null");
            this.typedBindingPattern = typedBindingPattern;
            return this;
        }

        public FromClauseNodeModifier withInKeyword(Token inKeyword) {
            Objects.requireNonNull(inKeyword, "inKeyword must not be null");
            this.inKeyword = inKeyword;
            return this;
        }

        public FromClauseNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public FromClauseNode apply() {
            return this.oldNode.modify(this.fromKeyword, this.typedBindingPattern, this.inKeyword, this.expression);
        }
    }
}

