/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ImplicitAnonymousFunctionParameters
extends NonTerminalNode {
    public ImplicitAnonymousFunctionParameters(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<SimpleNameReferenceNode> parameters() {
        return new SeparatedNodeList<SimpleNameReferenceNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParenToken", "parameters", "closeParenToken"};
    }

    public ImplicitAnonymousFunctionParameters modify(Token openParenToken, SeparatedNodeList<SimpleNameReferenceNode> parameters, Token closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, parameters.underlyingListNode(), closeParenToken)) {
            return this;
        }
        return NodeFactory.createImplicitAnonymousFunctionParameters(openParenToken, parameters, closeParenToken);
    }

    public ImplicitAnonymousFunctionParametersModifier modify() {
        return new ImplicitAnonymousFunctionParametersModifier(this);
    }

    public static class ImplicitAnonymousFunctionParametersModifier {
        private final ImplicitAnonymousFunctionParameters oldNode;
        private Token openParenToken;
        private SeparatedNodeList<SimpleNameReferenceNode> parameters;
        private Token closeParenToken;

        public ImplicitAnonymousFunctionParametersModifier(ImplicitAnonymousFunctionParameters oldNode) {
            this.oldNode = oldNode;
            this.openParenToken = oldNode.openParenToken();
            this.parameters = oldNode.parameters();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public ImplicitAnonymousFunctionParametersModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public ImplicitAnonymousFunctionParametersModifier withParameters(SeparatedNodeList<SimpleNameReferenceNode> parameters) {
            Objects.requireNonNull(parameters, "parameters must not be null");
            this.parameters = parameters;
            return this;
        }

        public ImplicitAnonymousFunctionParametersModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public ImplicitAnonymousFunctionParameters apply() {
            return this.oldNode.modify(this.openParenToken, this.parameters, this.closeParenToken);
        }
    }
}

