/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class NamedArgumentNode
extends FunctionArgumentNode {
    public NamedArgumentNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public SimpleNameReferenceNode argumentName() {
        return (SimpleNameReferenceNode)this.childInBucket(0);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"argumentName", "equalsToken", "expression"};
    }

    public NamedArgumentNode modify(SimpleNameReferenceNode argumentName, Token equalsToken, ExpressionNode expression) {
        if (this.checkForReferenceEquality(argumentName, equalsToken, expression)) {
            return this;
        }
        return NodeFactory.createNamedArgumentNode(argumentName, equalsToken, expression);
    }

    public NamedArgumentNodeModifier modify() {
        return new NamedArgumentNodeModifier(this);
    }

    public static class NamedArgumentNodeModifier {
        private final NamedArgumentNode oldNode;
        private SimpleNameReferenceNode argumentName;
        private Token equalsToken;
        private ExpressionNode expression;

        public NamedArgumentNodeModifier(NamedArgumentNode oldNode) {
            this.oldNode = oldNode;
            this.argumentName = oldNode.argumentName();
            this.equalsToken = oldNode.equalsToken();
            this.expression = oldNode.expression();
        }

        public NamedArgumentNodeModifier withArgumentName(SimpleNameReferenceNode argumentName) {
            Objects.requireNonNull(argumentName, "argumentName must not be null");
            this.argumentName = argumentName;
            return this;
        }

        public NamedArgumentNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public NamedArgumentNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public NamedArgumentNode apply() {
            return this.oldNode.modify(this.argumentName, this.equalsToken, this.expression);
        }
    }
}

