/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import java.util.Objects;
import java.util.Optional;

public class OnFailClauseNode
extends ClauseNode {
    public OnFailClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token onKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token failKeyword() {
        return (Token)this.childInBucket(1);
    }

    public Optional<TypedBindingPatternNode> typedBindingPattern() {
        return this.optionalChildInBucket(2);
    }

    public BlockStatementNode blockStatement() {
        return (BlockStatementNode)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"onKeyword", "failKeyword", "typedBindingPattern", "blockStatement"};
    }

    public OnFailClauseNode modify(Token onKeyword, Token failKeyword, TypedBindingPatternNode typedBindingPattern, BlockStatementNode blockStatement) {
        if (this.checkForReferenceEquality(onKeyword, failKeyword, typedBindingPattern, blockStatement)) {
            return this;
        }
        return NodeFactory.createOnFailClauseNode(onKeyword, failKeyword, typedBindingPattern, blockStatement);
    }

    public OnFailClauseNodeModifier modify() {
        return new OnFailClauseNodeModifier(this);
    }

    public static class OnFailClauseNodeModifier {
        private final OnFailClauseNode oldNode;
        private Token onKeyword;
        private Token failKeyword;
        private TypedBindingPatternNode typedBindingPattern;
        private BlockStatementNode blockStatement;

        public OnFailClauseNodeModifier(OnFailClauseNode oldNode) {
            this.oldNode = oldNode;
            this.onKeyword = oldNode.onKeyword();
            this.failKeyword = oldNode.failKeyword();
            this.typedBindingPattern = oldNode.typedBindingPattern().orElse(null);
            this.blockStatement = oldNode.blockStatement();
        }

        public OnFailClauseNodeModifier withOnKeyword(Token onKeyword) {
            Objects.requireNonNull(onKeyword, "onKeyword must not be null");
            this.onKeyword = onKeyword;
            return this;
        }

        public OnFailClauseNodeModifier withFailKeyword(Token failKeyword) {
            Objects.requireNonNull(failKeyword, "failKeyword must not be null");
            this.failKeyword = failKeyword;
            return this;
        }

        public OnFailClauseNodeModifier withTypedBindingPattern(TypedBindingPatternNode typedBindingPattern) {
            this.typedBindingPattern = typedBindingPattern;
            return this;
        }

        public OnFailClauseNodeModifier withBlockStatement(BlockStatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public OnFailClauseNode apply() {
            return this.oldNode.modify(this.onKeyword, this.failKeyword, this.typedBindingPattern, this.blockStatement);
        }
    }
}

