/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import java.util.Objects;

public class QueryPipelineNode
extends NonTerminalNode {
    public QueryPipelineNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public FromClauseNode fromClause() {
        return (FromClauseNode)this.childInBucket(0);
    }

    public NodeList<IntermediateClauseNode> intermediateClauses() {
        return new NodeList<IntermediateClauseNode>((NonTerminalNode)this.childInBucket(1));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"fromClause", "intermediateClauses"};
    }

    public QueryPipelineNode modify(FromClauseNode fromClause, NodeList<IntermediateClauseNode> intermediateClauses) {
        if (this.checkForReferenceEquality(fromClause, intermediateClauses.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createQueryPipelineNode(fromClause, intermediateClauses);
    }

    public QueryPipelineNodeModifier modify() {
        return new QueryPipelineNodeModifier(this);
    }

    public static class QueryPipelineNodeModifier {
        private final QueryPipelineNode oldNode;
        private FromClauseNode fromClause;
        private NodeList<IntermediateClauseNode> intermediateClauses;

        public QueryPipelineNodeModifier(QueryPipelineNode oldNode) {
            this.oldNode = oldNode;
            this.fromClause = oldNode.fromClause();
            this.intermediateClauses = oldNode.intermediateClauses();
        }

        public QueryPipelineNodeModifier withFromClause(FromClauseNode fromClause) {
            Objects.requireNonNull(fromClause, "fromClause must not be null");
            this.fromClause = fromClause;
            return this;
        }

        public QueryPipelineNodeModifier withIntermediateClauses(NodeList<IntermediateClauseNode> intermediateClauses) {
            Objects.requireNonNull(intermediateClauses, "intermediateClauses must not be null");
            this.intermediateClauses = intermediateClauses;
            return this;
        }

        public QueryPipelineNode apply() {
            return this.oldNode.modify(this.fromClause, this.intermediateClauses);
        }
    }
}

