/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class RecordTypeDescriptorNode
extends TypeDescriptorNode {
    public RecordTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token recordKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Token bodyStartDelimiter() {
        return (Token)this.childInBucket(1);
    }

    public NodeList<Node> fields() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(2));
    }

    public Optional<RecordRestDescriptorNode> recordRestDescriptor() {
        return this.optionalChildInBucket(3);
    }

    public Token bodyEndDelimiter() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"recordKeyword", "bodyStartDelimiter", "fields", "recordRestDescriptor", "bodyEndDelimiter"};
    }

    public RecordTypeDescriptorNode modify(Token recordKeyword, Token bodyStartDelimiter, NodeList<Node> fields, RecordRestDescriptorNode recordRestDescriptor, Token bodyEndDelimiter) {
        if (this.checkForReferenceEquality(recordKeyword, bodyStartDelimiter, fields.underlyingListNode(), recordRestDescriptor, bodyEndDelimiter)) {
            return this;
        }
        return NodeFactory.createRecordTypeDescriptorNode(recordKeyword, bodyStartDelimiter, fields, recordRestDescriptor, bodyEndDelimiter);
    }

    public RecordTypeDescriptorNodeModifier modify() {
        return new RecordTypeDescriptorNodeModifier(this);
    }

    public static class RecordTypeDescriptorNodeModifier {
        private final RecordTypeDescriptorNode oldNode;
        private Token recordKeyword;
        private Token bodyStartDelimiter;
        private NodeList<Node> fields;
        private RecordRestDescriptorNode recordRestDescriptor;
        private Token bodyEndDelimiter;

        public RecordTypeDescriptorNodeModifier(RecordTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.recordKeyword = oldNode.recordKeyword();
            this.bodyStartDelimiter = oldNode.bodyStartDelimiter();
            this.fields = oldNode.fields();
            this.recordRestDescriptor = oldNode.recordRestDescriptor().orElse(null);
            this.bodyEndDelimiter = oldNode.bodyEndDelimiter();
        }

        public RecordTypeDescriptorNodeModifier withRecordKeyword(Token recordKeyword) {
            Objects.requireNonNull(recordKeyword, "recordKeyword must not be null");
            this.recordKeyword = recordKeyword;
            return this;
        }

        public RecordTypeDescriptorNodeModifier withBodyStartDelimiter(Token bodyStartDelimiter) {
            Objects.requireNonNull(bodyStartDelimiter, "bodyStartDelimiter must not be null");
            this.bodyStartDelimiter = bodyStartDelimiter;
            return this;
        }

        public RecordTypeDescriptorNodeModifier withFields(NodeList<Node> fields) {
            Objects.requireNonNull(fields, "fields must not be null");
            this.fields = fields;
            return this;
        }

        public RecordTypeDescriptorNodeModifier withRecordRestDescriptor(RecordRestDescriptorNode recordRestDescriptor) {
            this.recordRestDescriptor = recordRestDescriptor;
            return this;
        }

        public RecordTypeDescriptorNodeModifier withBodyEndDelimiter(Token bodyEndDelimiter) {
            Objects.requireNonNull(bodyEndDelimiter, "bodyEndDelimiter must not be null");
            this.bodyEndDelimiter = bodyEndDelimiter;
            return this;
        }

        public RecordTypeDescriptorNode apply() {
            return this.oldNode.modify(this.recordKeyword, this.bodyStartDelimiter, this.fields, this.recordRestDescriptor, this.bodyEndDelimiter);
        }
    }
}

