/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class RestBindingPatternNode
extends BindingPatternNode {
    public RestBindingPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ellipsisToken() {
        return (Token)this.childInBucket(0);
    }

    public SimpleNameReferenceNode variableName() {
        return (SimpleNameReferenceNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ellipsisToken", "variableName"};
    }

    public RestBindingPatternNode modify(Token ellipsisToken, SimpleNameReferenceNode variableName) {
        if (this.checkForReferenceEquality(ellipsisToken, variableName)) {
            return this;
        }
        return NodeFactory.createRestBindingPatternNode(ellipsisToken, variableName);
    }

    public RestBindingPatternNodeModifier modify() {
        return new RestBindingPatternNodeModifier(this);
    }

    public static class RestBindingPatternNodeModifier {
        private final RestBindingPatternNode oldNode;
        private Token ellipsisToken;
        private SimpleNameReferenceNode variableName;

        public RestBindingPatternNodeModifier(RestBindingPatternNode oldNode) {
            this.oldNode = oldNode;
            this.ellipsisToken = oldNode.ellipsisToken();
            this.variableName = oldNode.variableName();
        }

        public RestBindingPatternNodeModifier withEllipsisToken(Token ellipsisToken) {
            Objects.requireNonNull(ellipsisToken, "ellipsisToken must not be null");
            this.ellipsisToken = ellipsisToken;
            return this;
        }

        public RestBindingPatternNodeModifier withVariableName(SimpleNameReferenceNode variableName) {
            Objects.requireNonNull(variableName, "variableName must not be null");
            this.variableName = variableName;
            return this;
        }

        public RestBindingPatternNode apply() {
            return this.oldNode.modify(this.ellipsisToken, this.variableName);
        }
    }
}

