/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ReturnTypeDescriptorNode
extends NonTerminalNode {
    public ReturnTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token returnsKeyword() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Node type() {
        return this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"returnsKeyword", "annotations", "type"};
    }

    public ReturnTypeDescriptorNode modify(Token returnsKeyword, NodeList<AnnotationNode> annotations, Node type) {
        if (this.checkForReferenceEquality(returnsKeyword, annotations.underlyingListNode(), type)) {
            return this;
        }
        return NodeFactory.createReturnTypeDescriptorNode(returnsKeyword, annotations, type);
    }

    public ReturnTypeDescriptorNodeModifier modify() {
        return new ReturnTypeDescriptorNodeModifier(this);
    }

    public static class ReturnTypeDescriptorNodeModifier {
        private final ReturnTypeDescriptorNode oldNode;
        private Token returnsKeyword;
        private NodeList<AnnotationNode> annotations;
        private Node type;

        public ReturnTypeDescriptorNodeModifier(ReturnTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.returnsKeyword = oldNode.returnsKeyword();
            this.annotations = oldNode.annotations();
            this.type = oldNode.type();
        }

        public ReturnTypeDescriptorNodeModifier withReturnsKeyword(Token returnsKeyword) {
            Objects.requireNonNull(returnsKeyword, "returnsKeyword must not be null");
            this.returnsKeyword = returnsKeyword;
            return this;
        }

        public ReturnTypeDescriptorNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public ReturnTypeDescriptorNodeModifier withType(Node type) {
            Objects.requireNonNull(type, "type must not be null");
            this.type = type;
            return this;
        }

        public ReturnTypeDescriptorNode apply() {
            return this.oldNode.modify(this.returnsKeyword, this.annotations, this.type);
        }
    }
}

