/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLItemNode;
import java.util.Objects;

public class XMLComment
extends XMLItemNode {
    public XMLComment(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token commentStart() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<Node> content() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token commentEnd() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"commentStart", "content", "commentEnd"};
    }

    public XMLComment modify(Token commentStart, NodeList<Node> content, Token commentEnd) {
        if (this.checkForReferenceEquality(commentStart, content.underlyingListNode(), commentEnd)) {
            return this;
        }
        return NodeFactory.createXMLComment(commentStart, content, commentEnd);
    }

    public XMLCommentModifier modify() {
        return new XMLCommentModifier(this);
    }

    public static class XMLCommentModifier {
        private final XMLComment oldNode;
        private Token commentStart;
        private NodeList<Node> content;
        private Token commentEnd;

        public XMLCommentModifier(XMLComment oldNode) {
            this.oldNode = oldNode;
            this.commentStart = oldNode.commentStart();
            this.content = oldNode.content();
            this.commentEnd = oldNode.commentEnd();
        }

        public XMLCommentModifier withCommentStart(Token commentStart) {
            Objects.requireNonNull(commentStart, "commentStart must not be null");
            this.commentStart = commentStart;
            return this;
        }

        public XMLCommentModifier withContent(NodeList<Node> content) {
            Objects.requireNonNull(content, "content must not be null");
            this.content = content;
            return this;
        }

        public XMLCommentModifier withCommentEnd(Token commentEnd) {
            Objects.requireNonNull(commentEnd, "commentEnd must not be null");
            this.commentEnd = commentEnd;
            return this;
        }

        public XMLComment apply() {
            return this.oldNode.modify(this.commentStart, this.content, this.commentEnd);
        }
    }
}

