/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import java.util.Objects;

public class XMLSimpleNameNode
extends XMLNameNode {
    public XMLSimpleNameNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token name() {
        return (Token)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"name"};
    }

    public XMLSimpleNameNode modify(Token name) {
        if (this.checkForReferenceEquality(name)) {
            return this;
        }
        return NodeFactory.createXMLSimpleNameNode(name);
    }

    public XMLSimpleNameNodeModifier modify() {
        return new XMLSimpleNameNodeModifier(this);
    }

    public static class XMLSimpleNameNodeModifier {
        private final XMLSimpleNameNode oldNode;
        private Token name;

        public XMLSimpleNameNodeModifier(XMLSimpleNameNode oldNode) {
            this.oldNode = oldNode;
            this.name = oldNode.name();
        }

        public XMLSimpleNameNodeModifier withName(Token name) {
            Objects.requireNonNull(name, "name must not be null");
            this.name = name;
            return this;
        }

        public XMLSimpleNameNode apply() {
            return this.oldNode.modify(this.name);
        }
    }
}

