/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.util.DefaultTraverserContext;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@PublicApi
public class NodeTraverser {
    private final Map<Class<?>, Object> rootVars;
    private final Function<? super Node, ? extends List<Node>> getChildren;

    public NodeTraverser(Map<Class<?>, Object> rootVars, Function<? super Node, ? extends List<Node>> getChildren) {
        this.rootVars = rootVars;
        this.getChildren = getChildren;
    }

    public NodeTraverser() {
        this(ImmutableKit.emptyMap(), Node::getChildren);
    }

    public Object depthFirst(NodeVisitor nodeVisitor, Node root) {
        return this.depthFirst(nodeVisitor, Collections.singleton(root));
    }

    public Object depthFirst(final NodeVisitor nodeVisitor, Collection<? extends Node> roots) {
        TraverserVisitor<Node> nodeTraverserVisitor = new TraverserVisitor<Node>(){

            @Override
            public TraversalControl enter(TraverserContext<Node> context) {
                return context.thisNode().accept(context, nodeVisitor);
            }

            @Override
            public TraversalControl leave(TraverserContext<Node> context) {
                return context.thisNode().accept(context, nodeVisitor);
            }
        };
        return this.doTraverse(roots, nodeTraverserVisitor);
    }

    public Object preOrder(NodeVisitor nodeVisitor, Node root) {
        return this.preOrder(nodeVisitor, Collections.singleton(root));
    }

    public Object preOrder(final NodeVisitor nodeVisitor, Collection<? extends Node> roots) {
        TraverserVisitor<Node> nodeTraverserVisitor = new TraverserVisitor<Node>(){

            @Override
            public TraversalControl enter(TraverserContext<Node> context) {
                return context.thisNode().accept(context, nodeVisitor);
            }

            @Override
            public TraversalControl leave(TraverserContext<Node> context) {
                return TraversalControl.CONTINUE;
            }
        };
        return this.doTraverse(roots, nodeTraverserVisitor);
    }

    public Object postOrder(NodeVisitor nodeVisitor, Node root) {
        return this.postOrder(nodeVisitor, Collections.singleton(root));
    }

    public Object postOrder(final NodeVisitor nodeVisitor, Collection<? extends Node> roots) {
        TraverserVisitor<Node> nodeTraverserVisitor = new TraverserVisitor<Node>(){

            @Override
            public TraversalControl enter(TraverserContext<Node> context) {
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl leave(TraverserContext<Node> context) {
                return context.thisNode().accept(context, nodeVisitor);
            }
        };
        return this.doTraverse(roots, nodeTraverserVisitor);
    }

    private Object doTraverse(Collection<? extends Node> roots, TraverserVisitor traverserVisitor) {
        Traverser<? super Node> nodeTraverser = Traverser.depthFirst(this.getChildren);
        nodeTraverser.rootVars(this.rootVars);
        return nodeTraverser.traverse(roots, (TraverserVisitor<? super Node>)traverserVisitor).getAccumulatedResult();
    }

    public static <T> T oneVisitWithResult(Node node, NodeVisitor nodeVisitor) {
        DefaultTraverserContext<Node> context = DefaultTraverserContext.simple(node);
        node.accept(context, nodeVisitor);
        return (T)context.getNewAccumulate();
    }
}

