/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.exception;

import graphql.language.SourceLocation;
import graphql.validation.ValidationError;
import io.ballerina.graphql.cmd.DiagnosticMessages;
import io.ballerina.graphql.cmd.GraphqlDiagnostic;
import io.ballerina.graphql.cmd.Utils;
import io.ballerina.graphql.exception.ValidationException;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;

public class QueryValidationException
extends ValidationException {
    private String message;
    List<ValidationError> errors;
    private String projectName;

    public QueryValidationException(String message, List<ValidationError> errors, String projectName) {
        super(message);
        this.message = message;
        this.errors = new ArrayList<ValidationError>(errors);
        this.projectName = projectName;
    }

    public QueryValidationException(String message, List<ValidationError> errors) {
        super(message);
        this.message = message;
        this.errors = new ArrayList<ValidationError>(errors);
    }

    public QueryValidationException(String message, Throwable e) {
        super(message, e);
    }

    public QueryValidationException(String message) {
        super(message);
    }

    @Override
    public String getMessage() {
        ArrayList<String> messages = new ArrayList<String>();
        for (ValidationError error : this.errors) {
            for (final SourceLocation sourceLocation : error.getLocations()) {
                Location location = new Location(){

                    public LineRange lineRange() {
                        LinePosition startLine = LinePosition.from((int)sourceLocation.getLine(), (int)sourceLocation.getColumn());
                        LinePosition endLine = LinePosition.from((int)sourceLocation.getLine(), (int)sourceLocation.getColumn());
                        return LineRange.from((String)(sourceLocation.getSourceName() != null ? "(" + QueryValidationException.this.projectName + ":" + sourceLocation.getSourceName() + ")" : "(" + QueryValidationException.this.projectName + ":)"), (LinePosition)startLine, (LinePosition)endLine);
                    }

                    public TextRange textRange() {
                        return TextRange.from((int)0, (int)0);
                    }
                };
                GraphqlDiagnostic graphqlDiagnostic = Utils.constructGraphqlDiagnostic(DiagnosticMessages.GRAPHQL_CLI_107.getCode(), error.getMessage(), DiagnosticSeverity.ERROR, location, new Object[0]);
                messages.add(graphqlDiagnostic.toString());
            }
        }
        StringBuilder concatenatedMessage = new StringBuilder();
        for (String message : messages) {
            concatenatedMessage.append(message).append("\n");
        }
        concatenatedMessage.append("GraphQL Query validation errors in project : ").append(this.projectName);
        concatenatedMessage.append("\n").append(this.message);
        return concatenatedMessage.toString();
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        return "GraphqlQueryValidationErrors{errors=" + String.valueOf(this.errors) + "}";
    }
}

