/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.diagramutil;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ChildNodeEntry;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.diagramutil.JSONGenerationException;
import org.ballerinalang.diagramutil.SyntaxTreeDiagnosticsUtil;

public class SyntaxTreeMapGenerator
extends NodeTransformer<JsonElement> {
    private SemanticModel semanticModel;
    private final List<JsonObject> visibleEpsForEachBlock;
    private final List<JsonObject> visibleEpsForModule;
    private final List<JsonObject> visibleEpsForClass;

    public SyntaxTreeMapGenerator(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
        this.visibleEpsForEachBlock = new ArrayList<JsonObject>();
        this.visibleEpsForModule = new ArrayList<JsonObject>();
        this.visibleEpsForClass = new ArrayList<JsonObject>();
    }

    public SyntaxTreeMapGenerator() {
        this.visibleEpsForEachBlock = new ArrayList<JsonObject>();
        this.visibleEpsForModule = new ArrayList<JsonObject>();
        this.visibleEpsForClass = new ArrayList<JsonObject>();
    }

    public JsonElement transform(ModulePartNode modulePartNode) {
        modulePartNode.members().forEach(node -> {
            try {
                if (this.semanticModel != null) {
                    ObjectTypeSymbol objectTypeSymbol;
                    boolean isEndpoint;
                    TypeSymbol rawType;
                    LineRange lineRange = node.children().get(2).lineRange();
                    Optional typeSymbol = this.semanticModel.type(lineRange);
                    if (typeSymbol.isEmpty()) {
                        typeSymbol = this.semanticModel.type(node.children().get(3).lineRange());
                    }
                    if (typeSymbol.isPresent() && (rawType = this.getRawType((TypeSymbol)typeSymbol.get())).typeKind() == TypeDescKind.OBJECT && (isEndpoint = (objectTypeSymbol = (ObjectTypeSymbol)rawType).qualifiers().contains(Qualifier.CLIENT))) {
                        this.updateVisibleEP((Node)node, (TypeSymbol)typeSymbol.get(), false);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
            }
            catch (AssertionError | Exception object) {
                // empty catch block
            }
        });
        return this.transformSyntaxNode((Node)modulePartNode);
    }

    public JsonElement transform(ClassDefinitionNode classDefinitionNode) {
        classDefinitionNode.members().forEach(this::findAndUpdateClientNode);
        JsonElement classDefinitionJson = this.transformSyntaxNode((Node)classDefinitionNode);
        this.visibleEpsForClass.clear();
        return classDefinitionJson;
    }

    public JsonElement transform(ServiceDeclarationNode serviceDeclarationNode) {
        serviceDeclarationNode.members().forEach(this::findAndUpdateClientNode);
        JsonElement seviceDeclarationJson = this.transformSyntaxNode((Node)serviceDeclarationNode);
        this.visibleEpsForClass.clear();
        return seviceDeclarationJson;
    }

    private void findAndUpdateClientNode(Node node) {
        try {
            if (this.semanticModel != null) {
                ObjectTypeSymbol objectTypeSymbol;
                boolean isEndpoint;
                TypeSymbol rawType;
                LineRange lineRange = node.lineRange();
                Optional typeSymbol = this.semanticModel.type(lineRange);
                if (typeSymbol.isEmpty()) {
                    ObjectFieldNode objectFieldNode = (ObjectFieldNode)node;
                    typeSymbol = this.semanticModel.type(objectFieldNode.children().get(1).lineRange());
                }
                if (typeSymbol.isPresent() && (rawType = this.getRawType((TypeSymbol)typeSymbol.get())).typeKind() == TypeDescKind.OBJECT && (isEndpoint = (objectTypeSymbol = (ObjectTypeSymbol)rawType).qualifiers().contains(Qualifier.CLIENT))) {
                    this.updateVisibleEP(node, (TypeSymbol)typeSymbol.get(), false);
                }
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (AssertionError | Exception object) {
            // empty catch block
        }
    }

    protected JsonElement transformSyntaxNode(Node node) {
        JsonObject nodeJson = new JsonObject();
        NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
        for (ChildNodeEntry childNodeEntry : nonTerminalNode.childEntries()) {
            if (childNodeEntry.isList()) {
                JsonArray childList = new JsonArray();
                for (Node listChildNode : childNodeEntry.nodeList()) {
                    childList.add(this.apply(listChildNode));
                }
                nodeJson.add(childNodeEntry.name(), (JsonElement)childList);
                continue;
            }
            if (!childNodeEntry.node().isPresent()) continue;
            nodeJson.add(childNodeEntry.name(), this.apply((Node)childNodeEntry.node().get()));
        }
        nodeJson.addProperty("source", node.toSourceCode());
        nodeJson.addProperty("kind", this.prettifyKind(node.kind().toString()));
        Iterable syntaxDiagnostics = node.diagnostics();
        if (syntaxDiagnostics != null) {
            nodeJson.add("syntaxDiagnostics", (JsonElement)SyntaxTreeDiagnosticsUtil.getDiagnostics(syntaxDiagnostics));
        }
        try {
            nodeJson.add("trailingMinutiae", (JsonElement)this.evaluateMinutiae(node.trailingMinutiae()));
        }
        catch (Exception e) {
            nodeJson.add("trailingMinutiae", (JsonElement)new JsonObject());
        }
        try {
            nodeJson.add("leadingMinutiae", (JsonElement)this.evaluateMinutiae(node.leadingMinutiae()));
        }
        catch (Exception e) {
            nodeJson.add("leadingMinutiae", (JsonElement)new JsonObject());
        }
        if (node.lineRange() != null) {
            boolean hasVisibleEps;
            Object memberArray;
            LineRange lineRange = node.lineRange();
            LinePosition startLine = lineRange.startLine();
            LinePosition endLine = lineRange.endLine();
            JsonObject position = new JsonObject();
            position.addProperty("startLine", (Number)startLine.line());
            position.addProperty("startColumn", (Number)startLine.offset());
            position.addProperty("endLine", (Number)endLine.line());
            position.addProperty("endColumn", (Number)endLine.offset());
            nodeJson.add("position", (JsonElement)position);
            JsonObject symbolJson = new JsonObject();
            try {
                if (this.semanticModel != null) {
                    Optional<TypeSymbol> typeSymbol = this.semanticModel.type(lineRange);
                    if (node.kind() == SyntaxKind.OBJECT_FIELD) {
                        typeSymbol = this.getClientQualifierTypeSymbol((ObjectFieldNode)node);
                    }
                    if (typeSymbol.isPresent()) {
                        ObjectTypeSymbol objectTypeSymbol;
                        boolean isEndpoint;
                        TypeSymbol rawType = this.getRawType(typeSymbol.get());
                        if (rawType.typeKind() == TypeDescKind.OBJECT && (isEndpoint = (objectTypeSymbol = (ObjectTypeSymbol)rawType).qualifiers().contains(Qualifier.CLIENT))) {
                            symbolJson.addProperty("isEndpoint", Boolean.valueOf(true));
                            this.updateVisibleEP(node, typeSymbol.get(), false);
                        }
                        symbolJson.add("typeSymbol", this.generateTypeJson((Symbol)typeSymbol.get()));
                        if (typeSymbol.get().getModule().isPresent()) {
                            JsonObject typeDataJson = (JsonObject)this.generateTypeJson((Symbol)typeSymbol.get().getModule().get());
                            ((JsonObject)symbolJson.get("typeSymbol")).add("moduleID", typeDataJson.get("id"));
                        } else if (typeSymbol.get() instanceof UnionTypeSymbol) {
                            memberArray = new JsonArray();
                            ((UnionTypeSymbol)typeSymbol.get()).memberTypeDescriptors().forEach(member -> {
                                try {
                                    JsonObject memberJson = (JsonObject)this.generateTypeJson((Symbol)member);
                                    memberArray.add((JsonElement)memberJson);
                                }
                                catch (JSONGenerationException jSONGenerationException) {
                                    // empty catch block
                                }
                            });
                            ((JsonObject)symbolJson.get("typeSymbol")).add("members", memberArray);
                        }
                    }
                }
            }
            catch (RuntimeException typeSymbol) {
            }
            catch (AssertionError | Exception typeSymbol) {
                // empty catch block
            }
            try {
                if (this.semanticModel != null) {
                    List diagnostics;
                    Optional symbol = this.semanticModel.symbol(node);
                    if (symbol.isPresent() && (memberArray = symbol.get()) instanceof VariableSymbol) {
                        VariableSymbol variableSymbol = (VariableSymbol)memberArray;
                        this.markVisibleEp(variableSymbol, symbolJson, node);
                    }
                    if (symbol.isPresent()) {
                        symbolJson.add("symbol", this.generateTypeJson((Symbol)symbol.get()));
                    }
                    if ((diagnostics = this.semanticModel.diagnostics(lineRange)) != null) {
                        symbolJson.add("diagnostics", (JsonElement)SyntaxTreeDiagnosticsUtil.getDiagnostics(diagnostics));
                    }
                }
                nodeJson.add("typeData", (JsonElement)symbolJson);
            }
            catch (AssertionError | NoSuchElementException | JSONGenerationException symbol) {
                // empty catch block
            }
            if (node.kind() == SyntaxKind.REMOTE_METHOD_CALL_ACTION) {
                Object t;
                RemoteMethodCallActionNode remoteMethodCallActionNode = (RemoteMethodCallActionNode)node;
                if (this.semanticModel != null && (expressionSymbol = this.semanticModel.symbol((Node)remoteMethodCallActionNode.expression())).isPresent() && (t = expressionSymbol.get()) instanceof VariableSymbol) {
                    variableSymbol = (VariableSymbol)t;
                    this.markVisibleEp(variableSymbol, symbolJson, (Node)remoteMethodCallActionNode.expression(), true);
                }
            } else if (node.kind() == SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION) {
                Object t;
                ClientResourceAccessActionNode resourceCallActionNode = (ClientResourceAccessActionNode)node;
                if (this.semanticModel != null && (expressionSymbol = this.semanticModel.symbol((Node)resourceCallActionNode.expression())).isPresent() && (t = expressionSymbol.get()) instanceof VariableSymbol) {
                    variableSymbol = (VariableSymbol)t;
                    this.markVisibleEp(variableSymbol, symbolJson, (Node)resourceCallActionNode.expression(), true);
                }
            }
            nodeJson.add("typeData", (JsonElement)symbolJson);
            boolean isBlockNode = node.kind() == SyntaxKind.BLOCK_STATEMENT || node.kind() == SyntaxKind.FUNCTION_BODY_BLOCK || node.kind() == SyntaxKind.SERVICE_DECLARATION;
            boolean bl = hasVisibleEps = !this.visibleEpsForEachBlock.isEmpty() || !this.visibleEpsForClass.isEmpty() || !this.visibleEpsForModule.isEmpty();
            if (isBlockNode && hasVisibleEps) {
                JsonArray blockEndpoints = new JsonArray();
                this.visibleEpsForModule.forEach(arg_0 -> ((JsonArray)blockEndpoints).add(arg_0));
                this.visibleEpsForClass.forEach(arg_0 -> ((JsonArray)blockEndpoints).add(arg_0));
                for (JsonObject endpoint : this.visibleEpsForEachBlock) {
                    int epStartLine = endpoint.get("position").getAsJsonObject().get("startLine").getAsInt();
                    int epEndLine = endpoint.get("position").getAsJsonObject().get("endLine").getAsInt();
                    Optional<Node> parentFunctionBlock = this.getParentBlock(node);
                    if (parentFunctionBlock.isPresent() && epStartLine >= parentFunctionBlock.get().lineRange().startLine().line() && epEndLine < node.lineRange().startLine().line() && !endpoint.has("innerBlock")) {
                        blockEndpoints.add((JsonElement)endpoint);
                    }
                    if (epStartLine < node.lineRange().startLine().line() || epEndLine >= node.lineRange().endLine().line() || endpoint.has("innerBlock")) continue;
                    blockEndpoints.add((JsonElement)endpoint);
                    endpoint.addProperty("innerBlock", Boolean.valueOf(true));
                }
                nodeJson.add("VisibleEndpoints", (JsonElement)blockEndpoints);
            }
        }
        return nodeJson;
    }

    private Optional<TypeSymbol> getClientQualifierTypeSymbol(ObjectFieldNode node) {
        if (node.metadata().isPresent()) {
            SyntaxKind[] kindArray = new SyntaxKind[]{SyntaxKind.QUALIFIED_NAME_REFERENCE, SyntaxKind.SIMPLE_NAME_REFERENCE};
            Optional<Node> clientNode = this.getChildNodeWithKind(node.children(), kindArray);
            if (clientNode.isPresent()) {
                return this.semanticModel.type(clientNode.get());
            }
        }
        return Optional.empty();
    }

    private Optional<Node> getChildNodeWithKind(ChildNodeList childNodeList, SyntaxKind[] kindArray) {
        for (Node node : childNodeList) {
            for (SyntaxKind kind : kindArray) {
                if (node.kind() != kind) continue;
                return Optional.of(node);
            }
        }
        return Optional.empty();
    }

    protected Optional<Node> getParentBlock(Node node) {
        try {
            if (node.kind() == SyntaxKind.FUNCTION_DEFINITION || node.kind() == SyntaxKind.SERVICE_DECLARATION) {
                return Optional.of(node);
            }
            return this.getParentBlock((Node)node.parent());
        }
        catch (NullPointerException ex) {
            return Optional.empty();
        }
    }

    private void markVisibleEp(VariableSymbol variableSymbol, JsonObject symbolJson, Node node) {
        ObjectTypeSymbol objectTypeSymbol;
        boolean isEndpoint;
        TypeSymbol rawType = this.getRawType(variableSymbol.typeDescriptor());
        if (rawType.typeKind() == TypeDescKind.OBJECT && (isEndpoint = (objectTypeSymbol = (ObjectTypeSymbol)rawType).qualifiers().contains(Qualifier.CLIENT))) {
            symbolJson.addProperty("isEndpoint", Boolean.valueOf(true));
            this.updateVisibleEP(node, rawType, false);
        }
        if (rawType.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)rawType;
            unionTypeSymbol.memberTypeDescriptors().forEach(member -> {
                TypeSymbol memberRawType = this.getRawType((TypeSymbol)member);
                if (memberRawType.typeKind() == TypeDescKind.OBJECT && ((ObjectTypeSymbol)memberRawType).qualifiers().contains(Qualifier.CLIENT)) {
                    symbolJson.addProperty("isEndpoint", Boolean.valueOf(true));
                    this.updateVisibleEP(node, memberRawType, false);
                }
            });
        }
    }

    private void markVisibleEp(VariableSymbol variableSymbol, JsonObject symbolJson, Node node, boolean isRemoteAction) {
        ObjectTypeSymbol objectTypeSymbol;
        boolean isEndpoint;
        TypeSymbol rawType = this.getRawType(variableSymbol.typeDescriptor());
        if (rawType.typeKind() == TypeDescKind.OBJECT && (isEndpoint = (objectTypeSymbol = (ObjectTypeSymbol)rawType).qualifiers().contains(Qualifier.CLIENT))) {
            symbolJson.addProperty("isEndpoint", Boolean.valueOf(true));
            this.updateVisibleEP(node, rawType, isRemoteAction);
        }
    }

    private JsonObject updateVisibleEP(Node node, TypeSymbol typeSymbol, boolean isRemoteAction) {
        JsonObject symbolMetaInfo = new JsonObject();
        switch (node.kind()) {
            case REQUIRED_PARAM: {
                RequiredParameterNode requiredParameterNode = (RequiredParameterNode)node;
                Optional paramName = requiredParameterNode.paramName();
                String symbolName = paramName.isPresent() ? ((Token)paramName.get()).text() : "";
                symbolMetaInfo = this.getModuleMetaInfo(typeSymbol, symbolName, requiredParameterNode.lineRange(), false, true);
                symbolMetaInfo.addProperty("isParameter", Boolean.valueOf(true));
                if (this.isAvailableAsEndpoint(symbolName)) break;
                this.visibleEpsForEachBlock.add(symbolMetaInfo);
                break;
            }
            case MODULE_VAR_DECL: {
                String moduleVarName;
                ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)node;
                if (moduleVariableDeclarationNode.typedBindingPattern().bindingPattern().kind() != SyntaxKind.CAPTURE_BINDING_PATTERN || this.isAvailableAsEndpoint(moduleVarName = ((CaptureBindingPatternNode)moduleVariableDeclarationNode.typedBindingPattern().bindingPattern()).variableName().text())) break;
                this.visibleEpsForModule.add(this.getModuleMetaInfo(typeSymbol, moduleVarName, moduleVariableDeclarationNode.lineRange(), true, true));
                break;
            }
            case OBJECT_FIELD: {
                ObjectFieldNode objectFieldNode = (ObjectFieldNode)node;
                String fieldName = objectFieldNode.fieldName().text();
                symbolMetaInfo = this.getModuleMetaInfo(typeSymbol, fieldName, objectFieldNode.lineRange(), false, true);
                symbolMetaInfo.addProperty("isClassField", Boolean.valueOf(true));
                if (this.isAvailableAsEndpoint(fieldName)) break;
                this.visibleEpsForClass.add(symbolMetaInfo);
                break;
            }
            case LOCAL_VAR_DECL: {
                VariableDeclarationNode variableDeclarationNode = (VariableDeclarationNode)node;
                if (variableDeclarationNode.typedBindingPattern().bindingPattern().kind() != SyntaxKind.CAPTURE_BINDING_PATTERN) break;
                String localVarName = ((CaptureBindingPatternNode)variableDeclarationNode.typedBindingPattern().bindingPattern()).variableName().text();
                symbolMetaInfo = this.getModuleMetaInfo(typeSymbol, localVarName, variableDeclarationNode.lineRange(), false, false);
                if (this.isAvailableAsEndpoint(localVarName)) break;
                this.visibleEpsForEachBlock.add(symbolMetaInfo);
                break;
            }
            case ASSIGNMENT_STATEMENT: {
                AssignmentStatementNode assignmentStatementNode = (AssignmentStatementNode)node;
                if (assignmentStatementNode.varRef().kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) break;
                String asgmtVarName = ((SimpleNameReferenceNode)assignmentStatementNode.varRef()).name().text();
                symbolMetaInfo = this.getModuleMetaInfo(typeSymbol, asgmtVarName, assignmentStatementNode.lineRange(), false, false);
                if (this.isAvailableAsEndpoint(asgmtVarName)) break;
                this.visibleEpsForEachBlock.add(symbolMetaInfo);
                break;
            }
            case SIMPLE_NAME_REFERENCE: {
                String name = ((SimpleNameReferenceNode)node).name().text();
                if (!isRemoteAction || this.isAvailableAsEndpoint(name)) break;
                this.visibleEpsForModule.add(this.getModuleMetaInfo(typeSymbol, name, node.lineRange(), false, true));
                break;
            }
            default: {
                return symbolMetaInfo;
            }
        }
        return symbolMetaInfo;
    }

    private JsonObject getModuleMetaInfo(TypeSymbol typeSymbol, String name, LineRange lineRange, Boolean isModuleVar, Boolean isExternal) {
        JsonObject metaInfo = new JsonObject();
        JsonObject position = new JsonObject();
        if (!typeSymbol.getModule().isPresent()) {
            return metaInfo;
        }
        ModuleID moduleID = ((ModuleSymbol)typeSymbol.getModule().get()).id();
        metaInfo.addProperty("name", name);
        metaInfo.addProperty("isCaller", Boolean.valueOf("Caller".equals(typeSymbol.getName().orElse(""))));
        metaInfo.addProperty("typeName", typeSymbol.getName().orElse(""));
        metaInfo.addProperty("orgName", moduleID.orgName());
        metaInfo.addProperty("packageName", moduleID.packageName());
        metaInfo.addProperty("moduleName", moduleID.moduleName());
        metaInfo.addProperty("version", moduleID.version());
        metaInfo.addProperty("isModuleVar", isModuleVar);
        metaInfo.addProperty("isExternal", isExternal);
        position.addProperty("startLine", (Number)lineRange.startLine().line());
        position.addProperty("endLine", (Number)lineRange.endLine().line());
        metaInfo.add("position", (JsonElement)position);
        return metaInfo;
    }

    private boolean isAvailableAsEndpoint(String name) {
        for (JsonObject ep : this.visibleEpsForEachBlock) {
            if (!ep.get("name").getAsString().equals(name) || ep.get("innerBlock") != null) continue;
            return true;
        }
        for (JsonObject ep : this.visibleEpsForModule) {
            if (!ep.get("name").getAsString().equals(name)) continue;
            return true;
        }
        for (JsonObject ep : this.visibleEpsForClass) {
            if (!ep.get("name").getAsString().equals(name)) continue;
            return true;
        }
        return false;
    }

    private TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        return typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE ? ((TypeReferenceTypeSymbol)typeDescriptor).typeDescriptor() : typeDescriptor;
    }

    private JsonElement generateTypeJson(Symbol symbol) throws JSONGenerationException {
        if (symbol == null) {
            return JsonNull.INSTANCE;
        }
        Set methods = ClassUtils.getAllInterfaces((Class)symbol.getClass()).stream().flatMap(aClass -> Arrays.stream(aClass.getMethods())).collect(Collectors.toSet());
        JsonObject nodeJson = new JsonObject();
        for (Method m : methods) {
            Object t;
            Optional optionalProp;
            String jsonName = m.getName();
            if (m.getParameterCount() > 0 || jsonName.equals("typeDefinitions") || jsonName.equals("functions") || jsonName.equals("classes") || jsonName.equals("constants") || jsonName.equals("listeners") || jsonName.equals("services") || jsonName.equals("allSymbols") || jsonName.equals("resources") || jsonName.equals("methods") || jsonName.equals("langLibMethods") || jsonName.equals("location")) continue;
            Object prop = null;
            try {
                prop = m.invoke((Object)symbol, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONGenerationException("Error occurred while generating JSON", e);
            }
            if (prop instanceof Symbol) {
                Symbol symbolProp = (Symbol)prop;
                if (jsonName.equals("typeDescriptor")) continue;
                nodeJson.add(jsonName, this.generateTypeJson(symbolProp));
                continue;
            }
            if (prop instanceof Optional && (optionalProp = (Optional)prop).isPresent() && (t = optionalProp.get()) instanceof ModuleSymbol) {
                ModuleSymbol moduleSymbol = (ModuleSymbol)t;
                ModuleID ballerinaModuleID = moduleSymbol.id();
                JsonObject moduleIdJson = new JsonObject();
                moduleIdJson.addProperty("orgName", ballerinaModuleID.orgName());
                moduleIdJson.addProperty("packageName", ballerinaModuleID.packageName());
                moduleIdJson.addProperty("moduleName", ballerinaModuleID.moduleName());
                moduleIdJson.addProperty("version", ballerinaModuleID.version());
                nodeJson.add("moduleID", (JsonElement)moduleIdJson);
                continue;
            }
            if (prop instanceof ModuleID) {
                ModuleID ballerinaModuleID = (ModuleID)prop;
                JsonObject moduleIdJson = new JsonObject();
                moduleIdJson.addProperty("orgName", ballerinaModuleID.orgName());
                moduleIdJson.addProperty("packageName", ballerinaModuleID.packageName());
                moduleIdJson.addProperty("moduleName", ballerinaModuleID.moduleName());
                moduleIdJson.addProperty("version", ballerinaModuleID.version());
                nodeJson.add(jsonName, (JsonElement)moduleIdJson);
                continue;
            }
            if (prop instanceof TypeDescKind) {
                TypeDescKind typeDescKind = (TypeDescKind)prop;
                nodeJson.addProperty(jsonName, typeDescKind.getName());
                continue;
            }
            if (prop instanceof SymbolKind) {
                SymbolKind symbolKind = (SymbolKind)prop;
                nodeJson.addProperty(jsonName, symbolKind.name());
                continue;
            }
            if (prop instanceof String) {
                String s = (String)prop;
                nodeJson.addProperty(jsonName, s);
                continue;
            }
            if (!(prop instanceof Boolean)) continue;
            Boolean b = (Boolean)prop;
            nodeJson.addProperty(jsonName, b);
        }
        return nodeJson;
    }

    private JsonElement apply(Node node) {
        JsonObject nodeInfo = new JsonObject();
        nodeInfo.addProperty("kind", this.prettifyKind(node.kind().toString()));
        if (node instanceof Token) {
            Token token = (Token)node;
            nodeInfo.addProperty("isToken", Boolean.valueOf(true));
            nodeInfo.addProperty("value", token.text());
            nodeInfo.addProperty("isMissing", Boolean.valueOf(node.isMissing()));
            if (node.lineRange() != null) {
                LineRange lineRange = node.lineRange();
                LinePosition startLine = lineRange.startLine();
                LinePosition endLine = lineRange.endLine();
                JsonObject position = new JsonObject();
                position.addProperty("startLine", (Number)startLine.line());
                position.addProperty("startColumn", (Number)startLine.offset());
                position.addProperty("endLine", (Number)endLine.line());
                position.addProperty("endColumn", (Number)endLine.offset());
                nodeInfo.add("position", (JsonElement)position);
            }
        } else {
            JsonElement memberValues = (JsonElement)node.apply((NodeTransformer)this);
            memberValues.getAsJsonObject().entrySet().forEach(memberEntry -> nodeInfo.add((String)memberEntry.getKey(), (JsonElement)memberEntry.getValue()));
        }
        try {
            nodeInfo.add("trailingMinutiae", (JsonElement)this.evaluateMinutiae(node.trailingMinutiae()));
        }
        catch (Exception e) {
            nodeInfo.add("trailingMinutiae", (JsonElement)new JsonObject());
        }
        try {
            nodeInfo.add("leadingMinutiae", (JsonElement)this.evaluateMinutiae(node.leadingMinutiae()));
        }
        catch (Exception e) {
            nodeInfo.add("leadingMinutiae", (JsonElement)new JsonObject());
        }
        return nodeInfo;
    }

    private String prettifyKind(String kind) {
        return Arrays.stream(kind.split("_")).map(String::toLowerCase).map(StringUtils::capitalize).collect(Collectors.joining());
    }

    private JsonArray evaluateMinutiae(MinutiaeList minutiaeList) {
        JsonArray nodeMinutiae = new JsonArray();
        for (Minutiae minutiae : minutiaeList) {
            JsonObject minutiaeJson = new JsonObject();
            minutiaeJson.addProperty("kind", minutiae.kind().toString());
            minutiaeJson.addProperty("minutiae", minutiae.text());
            minutiaeJson.addProperty("isInvalid", Boolean.valueOf(minutiae.isInvalidNodeMinutiae()));
            nodeMinutiae.add((JsonElement)minutiaeJson);
        }
        return nodeMinutiae;
    }
}

