/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.graphql.runtime.utils.ModuleUtils;
import java.util.concurrent.ConcurrentHashMap;

public class ExecutorVisitor {
    private static final String DATA_MAP = "dataMap";
    private static final String DATA_RECORD_NAME = "Data";
    private static final Object NullObject = new Object();
    private final ConcurrentHashMap<BString, Object> dataMap = new ConcurrentHashMap();

    private ExecutorVisitor() {
    }

    public static void initializeDataMap(BObject executorVisitor) {
        executorVisitor.addNativeData(DATA_MAP, (Object)new ExecutorVisitor());
    }

    public static void addData(BObject executorVisitor, BString key, Object value) {
        ExecutorVisitor visitor = (ExecutorVisitor)executorVisitor.getNativeData(DATA_MAP);
        visitor.addData(key, value);
    }

    public static BMap<BString, Object> getDataMap(BObject executorVisitor) {
        ExecutorVisitor visitor = (ExecutorVisitor)executorVisitor.getNativeData(DATA_MAP);
        return visitor.getDataMap();
    }

    private void addData(BString key, Object value) {
        this.dataMap.put(key, value == null ? NullObject : value);
    }

    private BMap<BString, Object> getDataMap() {
        BMap data = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)DATA_RECORD_NAME);
        this.dataMap.forEach((key, value) -> data.put(key, value.equals(NullObject) ? null : value));
        return data;
    }
}

