/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.runtime.engine;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.graphql.commons.types.Directive;
import io.ballerina.stdlib.graphql.commons.types.DirectiveLocation;
import io.ballerina.stdlib.graphql.commons.types.EnumValue;
import io.ballerina.stdlib.graphql.commons.types.Field;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.stdlib.graphql.runtime.engine.EngineUtils;
import io.ballerina.stdlib.graphql.runtime.utils.ModuleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SchemaRecordGenerator {
    private final Schema schema;
    private final Map<String, BMap<BString, Object>> typeRecords;

    public SchemaRecordGenerator(Schema schema) {
        this.schema = schema;
        this.schema.addSubgraphSchemaAdditions();
        this.typeRecords = new HashMap<String, BMap<BString, Object>>();
        this.populateTypeRecordMap();
        this.populateFieldsOfTypes();
    }

    public BMap<BString, Object> getSchemaRecord() {
        BMap schemaRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Schema");
        schemaRecord.put((Object)EngineUtils.DESCRIPTION_FIELD, (Object)StringUtils.fromString((String)this.schema.getDescription()));
        BArray typesArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Type"));
        for (BMap<BString, Object> typeRecord : this.typeRecords.values()) {
            typesArray.append(typeRecord);
        }
        schemaRecord.put((Object)EngineUtils.TYPES_FIELD, (Object)typesArray);
        schemaRecord.put((Object)EngineUtils.QUERY_TYPE_FIELD, this.typeRecords.get("Query"));
        schemaRecord.put((Object)EngineUtils.MUTATION_TYPE_FIELD, this.typeRecords.get("Mutation"));
        schemaRecord.put((Object)EngineUtils.SUBSCRIPTION_TYPE_FIELD, this.typeRecords.get("Subscription"));
        schemaRecord.put((Object)EngineUtils.DIRECTIVES_FIELD, (Object)this.getDirectives());
        schemaRecord.freezeDirect();
        return schemaRecord;
    }

    private void populateTypeRecordMap() {
        for (Type type : this.schema.getTypes().values()) {
            BMap typeRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Type");
            typeRecord.put((Object)EngineUtils.NAME_FIELD, (Object)StringUtils.fromString((String)type.getName()));
            typeRecord.put((Object)EngineUtils.KIND_FIELD, (Object)StringUtils.fromString((String)type.getKind().toString()));
            typeRecord.put((Object)EngineUtils.DESCRIPTION_FIELD, (Object)StringUtils.fromString((String)type.getDescription()));
            this.typeRecords.put(type.getName(), (BMap<BString, Object>)typeRecord);
        }
    }

    private void populateFieldsOfTypes() {
        for (Map.Entry entry : this.schema.getTypes().entrySet()) {
            Type type = (Type)entry.getValue();
            BMap<BString, Object> typeRecord = this.typeRecords.get(entry.getKey());
            if (type.getKind() == TypeKind.OBJECT || type.getKind() == TypeKind.INTERFACE) {
                typeRecord.put((Object)EngineUtils.FIELDS_FIELD, (Object)this.getFieldsArray(type));
                typeRecord.put((Object)EngineUtils.INTERFACES_FIELD, (Object)this.getInterfacesArray(type));
            }
            if (type.getKind() == TypeKind.INTERFACE || ((Type)entry.getValue()).getKind() == TypeKind.UNION) {
                typeRecord.put((Object)EngineUtils.POSSIBLE_TYPES_FIELD, (Object)this.getPossibleTypesArray(type));
            }
            if (type.getKind() == TypeKind.ENUM) {
                typeRecord.put((Object)EngineUtils.ENUM_VALUES_FIELD, (Object)this.getEnumValuesArray(type));
            }
            if (type.getKind() != TypeKind.INPUT_OBJECT) continue;
            typeRecord.put((Object)EngineUtils.INPUT_FIELDS_FIELD, (Object)this.getInputFieldsArray(type));
        }
    }

    private BMap<BString, Object> getTypeRecord(Type type) {
        BMap<BString, Object> typeRecord;
        if (this.typeRecords.containsKey(type.getName())) {
            typeRecord = this.typeRecords.get(type.getName());
        } else {
            typeRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Type");
            typeRecord.put((Object)EngineUtils.NAME_FIELD, (Object)StringUtils.fromString((String)type.getName()));
            typeRecord.put((Object)EngineUtils.KIND_FIELD, (Object)StringUtils.fromString((String)type.getKind().toString()));
            typeRecord.put((Object)EngineUtils.DESCRIPTION_FIELD, (Object)StringUtils.fromString((String)type.getDescription()));
        }
        if (type.getKind() == TypeKind.LIST || type.getKind() == TypeKind.NON_NULL) {
            typeRecord.put((Object)EngineUtils.OF_TYPE_FIELD, this.getTypeRecord(type.getOfType()));
        }
        return typeRecord;
    }

    private BArray getEnumValuesArray(Type type) {
        BArray enumValuesArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__EnumValue"));
        for (EnumValue enumValue : type.getEnumValues()) {
            enumValuesArray.append(this.getEnumValueRecord(enumValue));
        }
        return enumValuesArray;
    }

    private BMap<BString, Object> getEnumValueRecord(EnumValue enumValue) {
        BMap enumValueRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__EnumValue");
        enumValueRecord.put((Object)EngineUtils.NAME_FIELD, (Object)StringUtils.fromString((String)enumValue.getName()));
        enumValueRecord.put((Object)EngineUtils.DESCRIPTION_FIELD, (Object)StringUtils.fromString((String)enumValue.getDescription()));
        enumValueRecord.put((Object)EngineUtils.IS_DEPRECATED_FIELD, (Object)enumValue.isDeprecated());
        enumValueRecord.put((Object)EngineUtils.DEPRECATION_REASON_FIELD, (Object)StringUtils.fromString((String)enumValue.getDeprecationReason()));
        return enumValueRecord;
    }

    private BArray getPossibleTypesArray(Type type) {
        BArray possibleTypesArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Type"));
        for (Type possibleType : type.getPossibleTypes()) {
            possibleTypesArray.append(this.getTypeRecord(possibleType));
        }
        return possibleTypesArray;
    }

    private BArray getInterfacesArray(Type type) {
        BArray interfacesArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Type"));
        for (Type interfaceType : type.getInterfaces()) {
            interfacesArray.append(this.getTypeRecord(interfaceType));
        }
        return interfacesArray;
    }

    private BArray getFieldsArray(Type type) {
        BArray fieldsArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Field"));
        for (Field field : type.getFields()) {
            fieldsArray.append(this.getFieldRecord(field));
        }
        return fieldsArray;
    }

    private BArray getInputFieldsArray(Type type) {
        BArray inputFieldsArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__InputValue"));
        for (InputValue inputField : type.getInputFields()) {
            inputFieldsArray.append(this.getInputValueRecordFromInputValue(inputField));
        }
        return inputFieldsArray;
    }

    private BMap<BString, Object> getFieldRecord(Field field) {
        BMap fieldRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Field");
        fieldRecord.put((Object)EngineUtils.NAME_FIELD, (Object)StringUtils.fromString((String)field.getName()));
        fieldRecord.put((Object)EngineUtils.DESCRIPTION_FIELD, (Object)StringUtils.fromString((String)field.getDescription()));
        fieldRecord.put((Object)EngineUtils.TYPE_FIELD, this.getTypeRecord(field.getType()));
        fieldRecord.put((Object)EngineUtils.ARGS_FIELD, (Object)this.getInputValueArray(field.getArgs()));
        fieldRecord.put((Object)EngineUtils.IS_DEPRECATED_FIELD, (Object)field.isDeprecated());
        fieldRecord.put((Object)EngineUtils.DEPRECATION_REASON_FIELD, (Object)StringUtils.fromString((String)field.getDeprecationReason()));
        return fieldRecord;
    }

    private BArray getInputValueArray(List<InputValue> inputValues) {
        BArray inputValueArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__InputValue"));
        for (InputValue inputValue : inputValues) {
            inputValueArray.append(this.getInputValueRecordFromInputValue(inputValue));
        }
        return inputValueArray;
    }

    private BMap<BString, Object> getInputValueRecordFromInputValue(InputValue inputValue) {
        BMap inputValueRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__InputValue");
        inputValueRecord.put((Object)EngineUtils.NAME_FIELD, (Object)StringUtils.fromString((String)inputValue.getName()));
        inputValueRecord.put((Object)EngineUtils.DESCRIPTION_FIELD, (Object)StringUtils.fromString((String)inputValue.getDescription()));
        inputValueRecord.put((Object)EngineUtils.TYPE_FIELD, this.getTypeRecord(inputValue.getType()));
        inputValueRecord.put((Object)EngineUtils.DEFAULT_VALUE_FIELD, (Object)StringUtils.fromString((String)inputValue.getDefaultValue()));
        return inputValueRecord;
    }

    private BArray getDirectives() {
        BArray directivesArray = EngineUtils.getArrayTypeFromBMap((BMap<BString, Object>)ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Directive"));
        for (Directive directive : this.schema.getDirectives()) {
            directivesArray.append(this.getDirectiveRecord(directive));
        }
        return directivesArray;
    }

    private BMap<BString, Object> getDirectiveRecord(Directive directive) {
        BMap directiveRecord = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"__Directive");
        directiveRecord.put((Object)EngineUtils.NAME_FIELD, (Object)StringUtils.fromString((String)directive.getName()));
        directiveRecord.put((Object)EngineUtils.DESCRIPTION_FIELD, (Object)StringUtils.fromString((String)directive.getDescription()));
        directiveRecord.put((Object)EngineUtils.LOCATIONS_FIELD, (Object)this.getDirectiveLocationsArray(directive));
        directiveRecord.put((Object)EngineUtils.ARGS_FIELD, (Object)this.getInputValueArray(directive.getArgs()));
        return directiveRecord;
    }

    private BArray getDirectiveLocationsArray(Directive directive) {
        BArray directiveLocationsArray = ValueCreator.createArrayValue((ArrayType)this.getDirectiveLocationArrayType());
        for (DirectiveLocation location : directive.getLocations()) {
            directiveLocationsArray.append((Object)StringUtils.fromString((String)location.toString()));
        }
        return directiveLocationsArray;
    }

    private ArrayType getDirectiveLocationArrayType() {
        ArrayList<FiniteType> memberTypes = new ArrayList<FiniteType>(DirectiveLocation.values().length);
        for (DirectiveLocation directiveLocation : DirectiveLocation.values()) {
            memberTypes.add(TypeCreator.createFiniteType((String)directiveLocation.toString(), Set.of(StringUtils.fromString((String)directiveLocation.toString())), (int)2));
        }
        UnionType enumType = TypeCreator.createUnionType(memberTypes, (String)"__DirectiveLocation", (Module)ModuleUtils.getModule(), (int)0, (boolean)false, (long)0x200000020L);
        return TypeCreator.createArrayType((io.ballerina.runtime.api.types.Type)enumType);
    }
}

