/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.client;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.mqtt.utils.MqttUtils;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;

public class MqttClientCallbackImpl
implements MqttCallback {
    private final LinkedBlockingQueue blockingQueue;
    private final LinkedBlockingQueue deliveryTokenQueue;

    public MqttClientCallbackImpl(LinkedBlockingQueue blockingQueue, LinkedBlockingQueue deliveryTokenQueue) {
        this.blockingQueue = blockingQueue;
        this.deliveryTokenQueue = deliveryTokenQueue;
    }

    public void disconnected(MqttDisconnectResponse disconnectResponse) {
    }

    public void mqttErrorOccurred(MqttException exception) {
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        BMap<BString, Object> bMqttMessage = MqttUtils.getBMqttMessage(message, topic);
        this.blockingQueue.put(bMqttMessage);
    }

    public void deliveryComplete(IMqttToken token) {
        BMap<BString, Object> bMqttToken = MqttUtils.getMqttDeliveryToken(token);
        try {
            this.deliveryTokenQueue.put(bMqttToken);
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
    }

    public void connectComplete(boolean reconnect, String serverURI) {
    }

    public void authPacketArrived(int reasonCode, MqttProperties properties) {
    }
}

