/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.listener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.mqtt.listener.MqttListenerCallbackImpl;
import io.ballerina.stdlib.mqtt.utils.MqttConstants;
import io.ballerina.stdlib.mqtt.utils.MqttUtils;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttSubscription;

public final class ListenerActions {
    private ListenerActions() {
    }

    public static Object externInit(BObject clientObject, BString serverUri, BString clientId, BMap<BString, Object> listenerConfiguration) {
        try {
            MqttClient subscriber = new MqttClient(serverUri.getValue(), clientId.getValue(), (MqttClientPersistence)new MemoryPersistence());
            MqttConnectionOptions options = MqttUtils.getMqttConnectOptions(listenerConfiguration);
            boolean manualAcks = listenerConfiguration.getBooleanValue(StringUtils.fromString((String)"manualAcks"));
            subscriber.setManualAcks(manualAcks);
            subscriber.connect(options);
            clientObject.addNativeData("mqttClient", (Object)subscriber);
        }
        catch (BError e) {
            return e;
        }
        catch (Exception e) {
            return MqttUtils.createMqttError(e);
        }
        return null;
    }

    public static Object externAttach(Environment environment, BObject clientObject, BObject service, Object topics) {
        clientObject.addNativeData("service", (Object)service);
        MqttClient subscriber = (MqttClient)clientObject.getNativeData("mqttClient");
        subscriber.setCallback((MqttCallback)new MqttListenerCallbackImpl(environment, service, subscriber));
        return null;
    }

    public static Object externDetach(BObject clientObject, BObject service) {
        MqttClient subscriber = (MqttClient)clientObject.getNativeData("mqttClient");
        try {
            subscriber.disconnect();
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        clientObject.addNativeData("service", null);
        return null;
    }

    public static Object externStart(BObject clientObject, BArray subscriptions) {
        MqttClient subscriber = (MqttClient)clientObject.getNativeData("mqttClient");
        MqttSubscription[] mqttSubscriptions = new MqttSubscription[subscriptions.size()];
        for (int i = 0; i < subscriptions.size(); ++i) {
            BMap topicSubscription = (BMap)subscriptions.getValues()[i];
            mqttSubscriptions[i] = new MqttSubscription(topicSubscription.getStringValue(MqttConstants.TOPIC).getValue(), topicSubscription.getIntValue(MqttConstants.BQOS).intValue());
        }
        try {
            subscriber.subscribe(mqttSubscriptions);
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        return null;
    }

    public static Object externGracefulStop(BObject clientObject) {
        MqttClient subscriber = (MqttClient)clientObject.getNativeData("mqttClient");
        try {
            subscriber.disconnect();
            subscriber.close();
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        clientObject.addNativeData("service", null);
        return null;
    }

    public static Object externImmediateStop(BObject clientObject) {
        MqttClient subscriber = (MqttClient)clientObject.getNativeData("mqttClient");
        try {
            subscriber.disconnectForcibly();
            subscriber.close();
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        clientObject.addNativeData("service", null);
        return null;
    }
}

