/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.crypto.nativeimpl.Decode;
import io.ballerina.stdlib.mqtt.utils.ModuleUtils;
import io.ballerina.stdlib.mqtt.utils.MqttConstants;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.UUID;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;

public final class MqttUtils {
    private MqttUtils() {
    }

    public static BMap<BString, Object> getBMqttMessage(MqttMessage message, String topic) {
        BMap bMessage = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"Message");
        bMessage.put((Object)StringUtils.fromString((String)"payload"), (Object)ValueCreator.createArrayValue((byte[])message.getPayload()));
        bMessage.put((Object)StringUtils.fromString((String)"messageId"), (Object)message.getId());
        bMessage.put((Object)StringUtils.fromString((String)"qos"), (Object)message.getQos());
        bMessage.put((Object)StringUtils.fromString((String)"retained"), (Object)message.isRetained());
        bMessage.put((Object)StringUtils.fromString((String)"duplicate"), (Object)message.isDuplicate());
        bMessage.put((Object)MqttConstants.TOPIC, (Object)StringUtils.fromString((String)topic));
        MqttProperties properties = message.getProperties();
        if (Objects.nonNull(properties)) {
            BMap bMessageProperties = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"MessageProperties");
            if (Objects.nonNull(properties.getResponseTopic())) {
                bMessageProperties.put((Object)MqttConstants.RESPONSE_TOPIC, (Object)StringUtils.fromString((String)message.getProperties().getResponseTopic()));
            }
            if (Objects.nonNull(properties.getCorrelationData())) {
                bMessageProperties.put((Object)StringUtils.fromString((String)"correlationData"), (Object)ValueCreator.createArrayValue((byte[])message.getProperties().getCorrelationData()));
            }
            bMessage.put((Object)MqttConstants.MESSAGE_PROPERTIES, (Object)bMessageProperties);
        }
        return bMessage;
    }

    public static MqttMessage generateMqttMessage(BMap message) {
        MqttProperties properties = new MqttProperties();
        BMap bMessageProperties = message.getMapValue(MqttConstants.MESSAGE_PROPERTIES);
        if (Objects.nonNull(bMessageProperties)) {
            if (bMessageProperties.containsKey((Object)StringUtils.fromString((String)"correlationData"))) {
                properties.setCorrelationData(bMessageProperties.getArrayValue(StringUtils.fromString((String)"correlationData")).getByteArray());
            }
            if (bMessageProperties.containsKey((Object)MqttConstants.RESPONSE_TOPIC)) {
                properties.setResponseTopic(bMessageProperties.getStringValue(MqttConstants.RESPONSE_TOPIC).getValue());
            }
        }
        MqttMessage mqttMessage = new MqttMessage();
        mqttMessage.setPayload(((BArray)message.get((Object)StringUtils.fromString((String)"payload"))).getByteArray());
        mqttMessage.setQos(((Long)message.get((Object)StringUtils.fromString((String)"qos"))).intValue());
        mqttMessage.setRetained(((Boolean)message.get((Object)StringUtils.fromString((String)"retained"))).booleanValue());
        mqttMessage.setProperties(properties);
        return mqttMessage;
    }

    public static BMap<BString, Object> getMqttDeliveryToken(IMqttToken token) {
        BMap bDeliveryToken = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"DeliveryToken");
        bDeliveryToken.put((Object)StringUtils.fromString((String)"messageId"), (Object)token.getMessageId());
        bDeliveryToken.put((Object)MqttConstants.TOPIC, (Object)StringUtils.fromString((String)token.getTopics()[0]));
        return bDeliveryToken;
    }

    public static MqttConnectionOptions getMqttConnectOptions(BMap<BString, Object> configuration) {
        MqttConnectionOptions options = new MqttConnectionOptions();
        Object connectionConfigObject = configuration.get((Object)MqttConstants.CONNECTION_CONFIGURATION);
        if (Objects.nonNull(connectionConfigObject) && connectionConfigObject instanceof BMap) {
            Object secureSocket;
            Object automaticReconnect;
            Object serverUris;
            Object cleanStart;
            Object connectionTimeout;
            Object keepAliveInterval;
            Object maxReconnectDelay;
            Object password;
            BMap connectionConfig = (BMap)connectionConfigObject;
            Object username = connectionConfig.get((Object)MqttConstants.USERNAME);
            if (Objects.nonNull(username)) {
                options.setUserName(((BString)username).getValue());
            }
            if (Objects.nonNull(password = connectionConfig.get((Object)MqttConstants.PASSWORD))) {
                options.setPassword(((BString)password).getValue().getBytes(StandardCharsets.UTF_8));
            }
            if (Objects.nonNull(maxReconnectDelay = connectionConfig.get((Object)MqttConstants.MAX_RECONNECT_DELAY))) {
                options.setMaxReconnectDelay(((Long)maxReconnectDelay).intValue());
            }
            if (Objects.nonNull(keepAliveInterval = connectionConfig.get((Object)MqttConstants.KEEP_ALIVE_INTERVAL))) {
                options.setKeepAliveInterval(((Long)keepAliveInterval).intValue());
            }
            if (Objects.nonNull(connectionTimeout = connectionConfig.get((Object)MqttConstants.CONNECTION_TIMEOUT))) {
                options.setConnectionTimeout(((Long)connectionTimeout).intValue());
            }
            if (Objects.nonNull(cleanStart = connectionConfig.get((Object)MqttConstants.CLEAN_START))) {
                options.setCleanStart(((Boolean)cleanStart).booleanValue());
            }
            if (Objects.nonNull(serverUris = connectionConfig.get((Object)MqttConstants.SERVER_URIS))) {
                options.setServerURIs(((BArray)serverUris).getStringArray());
            }
            if (Objects.nonNull(automaticReconnect = connectionConfig.get((Object)MqttConstants.AUTOMATIC_RECONNECT))) {
                options.setAutomaticReconnect(((Boolean)automaticReconnect).booleanValue());
            }
            if (Objects.nonNull(secureSocket = connectionConfig.get((Object)MqttConstants.SECURE_SOCKET))) {
                SocketFactory socketFactory = MqttUtils.getSocketFactory((BMap<BString, Object>)((BMap)secureSocket));
                options.setSocketFactory(socketFactory);
            }
        }
        return options;
    }

    private static SocketFactory getSocketFactory(BMap<BString, Object> secureSocket) {
        Object bCert = secureSocket.get((Object)MqttConstants.CERT);
        BMap keyRecord = secureSocket.getMapValue(MqttConstants.KEY);
        BMap protocol = secureSocket.getMapValue(MqttConstants.PROTOCOL_NAME);
        Object contextProtocol = "TLSv1.2";
        KeyManagerFactory kmf = null;
        if (Objects.nonNull(protocol)) {
            String version = protocol.getStringValue(MqttConstants.PROTOCOL_VERSION).getValue();
            String protocolName = protocol.getStringValue(MqttConstants.PROTOCOL_NAME).getValue();
            contextProtocol = protocolName + "v" + version;
        }
        try {
            TrustManagerFactory tmf;
            Security.addProvider((Provider)new BouncyCastleProvider());
            if (bCert instanceof BString) {
                tmf = MqttUtils.getTrustManagerFactory((BString)bCert);
            } else {
                BMap trustStore = (BMap)bCert;
                tmf = MqttUtils.getTrustManagerFactory((BMap<BString, BString>)trustStore);
            }
            if (Objects.nonNull(keyRecord)) {
                if (keyRecord.containsKey((Object)MqttConstants.CERT_FILE)) {
                    BString certFile = (BString)keyRecord.get((Object)MqttConstants.CERT_FILE);
                    BString keyFile = (BString)keyRecord.get((Object)MqttConstants.KEY_FILE);
                    BString keyPassword = keyRecord.getStringValue(MqttConstants.KEY_PASSWORD);
                    kmf = MqttUtils.getKeyManagerFactory(certFile, keyFile, keyPassword);
                } else {
                    kmf = MqttUtils.getKeyManagerFactory((BMap<BString, BString>)keyRecord);
                }
            }
            SSLContext sslContext = SSLContext.getInstance((String)contextProtocol);
            if (Objects.nonNull(kmf)) {
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            } else {
                sslContext.init(null, tmf.getTrustManagers(), null);
            }
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw MqttUtils.createMqttError(e);
        }
    }

    private static KeyManagerFactory getKeyManagerFactory(BMap<BString, BString> keyStore) throws Exception {
        BString keyStorePath = keyStore.getStringValue(MqttConstants.KEY_STORE_PATH);
        BString keyStorePassword = keyStore.getStringValue(MqttConstants.KEY_STORE_PASSWORD);
        KeyStore ks = MqttUtils.getKeyStore(keyStorePath, keyStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword.getValue().toCharArray());
        return kmf;
    }

    private static KeyManagerFactory getKeyManagerFactory(BString certFile, BString keyFile, BString keyPassword) throws Exception {
        Object publicKey = Decode.decodeRsaPublicKeyFromCertFile((BString)certFile);
        if (publicKey instanceof BMap) {
            X509Certificate publicCert = (X509Certificate)((BMap)publicKey).getNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE");
            Object privateKeyMap = Decode.decodeRsaPrivateKeyFromKeyFile((BString)keyFile, (Object)keyPassword);
            if (privateKeyMap instanceof BMap) {
                PrivateKey privateKey = (PrivateKey)((BMap)privateKeyMap).getNativeData("NATIVE_DATA_PRIVATE_KEY");
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, "".toCharArray());
                ks.setKeyEntry(UUID.randomUUID().toString(), privateKey, "".toCharArray(), new X509Certificate[]{publicCert});
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, "".toCharArray());
                return kmf;
            }
            throw new Exception("Failed to get the private key from Crypto API. " + ((BError)privateKeyMap).getErrorMessage().getValue());
        }
        throw new Exception("Failed to get the public key from Crypto API. " + ((BError)publicKey).getErrorMessage().getValue());
    }

    private static TrustManagerFactory getTrustManagerFactory(BString cert) throws Exception {
        Object publicKeyMap = Decode.decodeRsaPublicKeyFromCertFile((BString)cert);
        if (publicKeyMap instanceof BMap) {
            X509Certificate x509Certificate = (X509Certificate)((BMap)publicKeyMap).getNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE");
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            ts.load(null, "".toCharArray());
            ts.setCertificateEntry(UUID.randomUUID().toString(), x509Certificate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            return tmf;
        }
        throw new Exception("Failed to get the public key from Crypto API. " + ((BError)publicKeyMap).getErrorMessage().getValue());
    }

    private static TrustManagerFactory getTrustManagerFactory(BMap<BString, BString> trustStore) throws Exception {
        BString trustStorePath = trustStore.getStringValue(MqttConstants.CRYPTO_TRUSTSTORE_PATH);
        BString trustStorePassword = trustStore.getStringValue(MqttConstants.CRYPTO_TRUSTSTORE_PASSWORD);
        KeyStore ts = MqttUtils.getKeyStore(trustStorePath, trustStorePassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        return tmf;
    }

    private static KeyStore getKeyStore(BString path, BString password) throws Exception {
        try (FileInputStream is = new FileInputStream(path.getValue());){
            char[] passphrase = password.getValue().toCharArray();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(is, passphrase);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    public static BError createMqttError(Exception exception) {
        Throwable cause = exception.getCause();
        BMap errorDetailMap = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"ErrorDetails");
        if (exception instanceof MqttException) {
            errorDetailMap.put((Object)MqttConstants.REASON_CODE, (Object)((MqttException)exception).getReasonCode());
        }
        if (Objects.nonNull(cause)) {
            return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"Error", (BString)StringUtils.fromString((String)exception.getMessage()), (BError)ErrorCreator.createError((Throwable)exception.getCause()), (BMap)errorDetailMap);
        }
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"Error", (BString)StringUtils.fromString((String)exception.getMessage()), null, (BMap)errorDetailMap);
    }
}

