/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public enum DiagnosticsCodes {
    PERSIST_001("PERSIST_001", "", DiagnosticSeverity.INTERNAL),
    PERSIST_002("PERSIST_002", "", DiagnosticSeverity.INTERNAL),
    PERSIST_003("PERSIST_003", "", DiagnosticSeverity.INTERNAL),
    PERSIST_004("PERSIST_004", "", DiagnosticSeverity.INTERNAL),
    PERSIST_005("PERSIST_005", "", DiagnosticSeverity.INTERNAL),
    PERSIST_101("PERSIST_101", "persist model definition only supports record and enum definitions", DiagnosticSeverity.ERROR),
    PERSIST_102("PERSIST_102", "persist model definition does not support import prefix", DiagnosticSeverity.ERROR),
    PERSIST_201("PERSIST_201", "an entity should be a closed record", DiagnosticSeverity.ERROR),
    PERSIST_202("PERSIST_202", "redeclared entity ''{0}''", DiagnosticSeverity.ERROR),
    PERSIST_301("PERSIST_301", "an entity does not support rest descriptor field", DiagnosticSeverity.ERROR),
    PERSIST_302("PERSIST_302", "an entity does not support defaultable field", DiagnosticSeverity.ERROR),
    PERSIST_303("PERSIST_303", "an entity does not support inherited field", DiagnosticSeverity.ERROR),
    PERSIST_304("PERSIST_304", "an entity does not support optional field", DiagnosticSeverity.ERROR),
    PERSIST_305("PERSIST_305", "an entity does not support {0}-typed field", DiagnosticSeverity.ERROR),
    PERSIST_306("PERSIST_306", "an entity does not support {0} array field type", DiagnosticSeverity.ERROR),
    PERSIST_307("PERSIST_307", "redeclared field ''{0}''", DiagnosticSeverity.ERROR),
    PERSIST_308("PERSIST_308", "an entity does not support nillable field", DiagnosticSeverity.ERROR),
    PERSIST_309("PERSIST_309", "an entity does not support optional readonly field", DiagnosticSeverity.ERROR),
    PERSIST_401("PERSIST_401", "an entity cannot reference itself in a relation field", DiagnosticSeverity.ERROR),
    PERSIST_402("PERSIST_402", "the related entity ''{0}'' does not have the corresponding relation field", DiagnosticSeverity.ERROR),
    PERSIST_403("PERSIST_403", "All relation between two entities should have a single owner", DiagnosticSeverity.ERROR),
    PERSIST_404("PERSIST_404", "1-1 relationship should have at least one relation field nillable to indicate non-owner of the relationship", DiagnosticSeverity.ERROR),
    PERSIST_405("PERSIST_405", "1-1 relationship should have only one nillable relation field", DiagnosticSeverity.ERROR),
    PERSIST_406("PERSIST_406", "1-n relationship does not support nillable relation field", DiagnosticSeverity.ERROR),
    PERSIST_420("PERSIST_420", "many-to-many relation is not supported yet", DiagnosticSeverity.ERROR),
    PERSIST_422("PERSIST_422", "the entity should not contain foreign key field ''{0}'' for relation ''{1}''", DiagnosticSeverity.ERROR),
    PERSIST_501("PERSIST_501", "''{0}'' entity must have at least one identity readonly field", DiagnosticSeverity.ERROR),
    PERSIST_502("PERSIST_502", "an identity field cannot be nillable", DiagnosticSeverity.ERROR),
    PERSIST_503("PERSIST_503", "only ''int'', ''string'', ''float'', ''boolean'', ''decimal'' types are supported as identity fields, found ''{0}''", DiagnosticSeverity.ERROR);

    private final String code;
    private final String message;
    private final DiagnosticSeverity severity;

    private DiagnosticsCodes(String code, String message, DiagnosticSeverity severity) {
        this.code = code;
        this.message = message;
        this.severity = severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public DiagnosticSeverity getSeverity() {
        return this.severity;
    }
}

